/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.networking;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.network.NetworkEvent;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.integration.MoonlightCompat;

public class C2SRemoveMarkerPacket {
    private final int hash;
    private final String mapId;

    public C2SRemoveMarkerPacket(FriendlyByteBuf buf) {
        this.hash = buf.m_130242_();
        this.mapId = buf.m_130277_();
    }

    public C2SRemoveMarkerPacket(String map, int hash) {
        this.hash = hash;
        this.mapId = map;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.hash);
        buf.m_130070_(this.mapId);
    }

    public void apply(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.f_19853_;
            MapItemSavedData data = level.m_7489_(this.mapId);
            if (data != null) {
                data.f_77894_.entrySet().removeIf(e -> ((MapDecoration)e.getValue()).hashCode() == this.hash);
            }
            if (MapAtlasesMod.MOONLIGHT) {
                MoonlightCompat.removeCustomDecoration(data, this.hash);
            }
        });
        context.get().setPacketHandled(true);
    }
}

