/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.networking;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class C2STeleportPacket {
    private final int x;
    private final int z;
    private final Integer y;
    private ResourceKey<Level> dimension;

    public C2STeleportPacket(FriendlyByteBuf buf) {
        this.x = buf.m_130242_();
        this.z = buf.m_130242_();
        this.y = buf.m_236860_(FriendlyByteBuf::m_130242_).orElse(null);
        this.dimension = buf.m_236801_(Registry.f_122819_);
    }

    public C2STeleportPacket(int x, int z, @Nullable Integer y, ResourceKey<Level> dimension) {
        this.x = x;
        this.z = z;
        this.y = y;
        this.dimension = dimension;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.x);
        buf.m_130130_(this.z);
        buf.m_236835_(Optional.ofNullable(this.y), FriendlyByteBuf::m_130130_);
        buf.m_236858_(this.dimension);
    }

    public void apply(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            int y;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_20194_().m_129880_(this.dimension);
            int n = this.y == null ? (level != player.f_19853_ ? level.m_151558_() : level.m_6924_(Heightmap.Types.MOTION_BLOCKING, this.x, this.z)) : (y = this.y.intValue());
            if (C2STeleportPacket.performTeleport(player, level, this.x, y, this.z)) {
                player.m_213846_((Component)Component.m_237110_((String)"commands.teleport.success.location.single", (Object[])new Object[]{player.m_5446_(), C2STeleportPacket.formatDouble(this.x), C2STeleportPacket.formatDouble(y), C2STeleportPacket.formatDouble(this.z)}));
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"commands.teleport.invalidPosition"));
            }
        });
        context.get().setPacketHandled(true);
    }

    private static boolean performTeleport(ServerPlayer player, ServerLevel pLevel, double pX, double pY, double pZ) {
        EntityTeleportEvent.TeleportCommand event = ForgeEventFactory.onEntityTeleportCommand((Entity)player, (double)pX, (double)pY, (double)pZ);
        if (event.isCanceled()) {
            return false;
        }
        pX = event.getTargetX();
        BlockPos blockpos = new BlockPos(pX, pY = event.getTargetY(), pZ = event.getTargetZ());
        if (Level.m_46741_((BlockPos)blockpos)) {
            player.m_8999_(pLevel, pX, pY, pZ, player.m_146908_(), player.m_146909_());
            if (!player.m_21255_()) {
                player.m_20256_(player.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, -5.0, 0.0));
                player.m_6853_(true);
            }
            return true;
        }
        return false;
    }

    private static String formatDouble(double pValue) {
        return String.format(Locale.ROOT, "%f", pValue);
    }
}

