/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.networking;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.client.MapAtlasesClient;

public class S2CSetMapDataPacket {
    public final String mapId;
    public final MapItemSavedData mapData;
    public final boolean isOnJoin;

    public S2CSetMapDataPacket(FriendlyByteBuf buf) {
        this.mapId = buf.m_130277_();
        CompoundTag nbt = buf.m_130260_();
        if (nbt == null) {
            MapAtlasesMod.LOGGER.warn("Null MapItemSavedData NBT received by client");
            this.mapData = null;
        } else {
            this.mapData = MapItemSavedData.m_164807_((CompoundTag)nbt);
        }
        this.isOnJoin = buf.readBoolean();
    }

    public S2CSetMapDataPacket(String mapId, MapItemSavedData mapData, boolean isOnJoin) {
        this.mapId = mapId;
        this.mapData = mapData;
        this.isOnJoin = isOnJoin;
    }

    public void write(FriendlyByteBuf buf) {
        CompoundTag mapAsTag = new CompoundTag();
        this.mapData.m_7176_(mapAsTag);
        buf.m_130070_(this.mapId);
        buf.m_130079_(mapAsTag);
        buf.writeBoolean(this.isOnJoin);
    }

    public void apply(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                MapAtlasesClient.setClientMapData(this);
            }
        });
        context.get().setPacketHandled(true);
    }
}

