/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.utils;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.utils.MapType;

public final class Slice {
    public static final Slice DEFAULT_INSTANCE = new Slice(MapType.VANILLA, null);
    private final MapType type;
    @Nullable
    private final Integer height;

    private Slice(MapType type, Integer height) {
        this.type = type;
        this.height = height;
    }

    public static Slice of(MapType type, @Nullable Integer height) {
        if (height != null && height.equals(Integer.MAX_VALUE)) {
            height = null;
        }
        if (height == null && type == MapType.VANILLA) {
            return DEFAULT_INSTANCE;
        }
        return new Slice(type, height);
    }

    public static Slice parse(CompoundTag t) {
        int anInt = t.m_128451_("type");
        if (anInt >= MapType.values().length) {
            anInt = 0;
        }
        return Slice.of(MapType.values()[anInt], t.m_128451_("height"));
    }

    public CompoundTag save() {
        CompoundTag t = new CompoundTag();
        t.m_128405_("type", this.type.ordinal());
        t.m_128405_("height", this.heightOrTop());
        return t;
    }

    public String toString() {
        return "Slice{type=" + this.type + ", height=" + this.height + "}";
    }

    @NotNull
    public int heightOrTop() {
        return this.height == null ? Integer.MAX_VALUE : this.height;
    }

    public MapType type() {
        return this.type;
    }

    @Nullable
    public Integer height() {
        return this.height;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Slice that = (Slice)obj;
        return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.height, that.height);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.height});
    }

    public String getMapString(int id) {
        return this.type.makeKey(id);
    }

    public boolean hasMarkers() {
        return this.type.hasMarkers();
    }

    public int getDiscoveryReach() {
        return this.type.getDiscoveryReach(this.height);
    }

    public ItemStack createNewMap(int destX, int destZ, byte scale, Level level) {
        return this.type.createNewMapItem(destX, destZ, scale, level, this.height);
    }
}

