/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal;

import com.seibel.distanthorizons.core.Initializer;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.util.objects.Pair;
import com.seibel.distanthorizons.core.util.threading.ThreadPools;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.DhClientServerWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.world.IDhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.ArrayList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SharedApi {
    public static final SharedApi INSTANCE = new SharedApi();
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final Set<DhChunkPos> UPDATING_CHUNK_SET = ConcurrentHashMap.newKeySet();
    private static final int MAX_UPDATING_CHUNK_COUNT_PER_THREAD = 100;
    private static AbstractDhWorld currentWorld;
    private static int lastWorldGenTickDelta;
    private static final Timer CHUNK_UPDATE_TIMER;

    private SharedApi() {
    }

    public static void init() {
        Initializer.init();
    }

    public static EWorldEnvironment getEnvironment() {
        return currentWorld == null ? null : SharedApi.currentWorld.environment;
    }

    public static void setDhWorld(AbstractDhWorld newWorld) {
        currentWorld = newWorld;
        if (currentWorld != null) {
            ThreadPools.setupThreadPools();
        } else {
            ThreadPools.shutdownThreadPools();
            DebugRenderer.clearRenderables();
            MC_RENDER.clearTargetFrameBuffer();
            System.gc();
        }
    }

    public static void worldGenTick(Runnable worldGenRunnable) {
        if (--lastWorldGenTickDelta <= 0) {
            worldGenRunnable.run();
            lastWorldGenTickDelta = 20;
        }
    }

    public static AbstractDhWorld getAbstractDhWorld() {
        return currentWorld;
    }

    public static DhClientServerWorld getDhClientServerWorld() {
        return currentWorld != null && DhClientServerWorld.class.isInstance(currentWorld) ? (DhClientServerWorld)currentWorld : null;
    }

    public static IDhClientWorld getIDhClientWorld() {
        return currentWorld != null && IDhClientWorld.class.isInstance(currentWorld) ? (IDhClientWorld)((Object)currentWorld) : null;
    }

    public static IDhServerWorld getIDhServerWorld() {
        return currentWorld != null && IDhServerWorld.class.isInstance(currentWorld) ? (IDhServerWorld)((Object)currentWorld) : null;
    }

    public void chunkBlockChangedEvent(IChunkWrapper chunk, ILevelWrapper level) {
        this.applyChunkUpdate(chunk, level, true);
    }

    public void chunkLoadEvent(IChunkWrapper chunk, ILevelWrapper level) {
        this.applyChunkUpdate(chunk, level, false);
    }

    public void chunkUnloadEvent(IChunkWrapper chunk, ILevelWrapper level) {
    }

    public void applyChunkUpdate(IChunkWrapper chunkWrapper, ILevelWrapper level, boolean updateNeighborChunks) {
        if (chunkWrapper == null) {
            return;
        }
        AbstractDhWorld dhWorld = SharedApi.getAbstractDhWorld();
        if (dhWorld == null) {
            if (level instanceof IClientLevelWrapper) {
                IClientLevelWrapper clientLevel = (IClientLevelWrapper)level;
                ClientApi.INSTANCE.waitingChunkByClientLevelAndPos.replace(new Pair<IClientLevelWrapper, DhChunkPos>(clientLevel, chunkWrapper.getChunkPos()), chunkWrapper);
            }
            return;
        }
        IDhLevel dhLevel = dhWorld.getLevel(level);
        if (dhLevel == null) {
            if (level instanceof IClientLevelWrapper) {
                IClientLevelWrapper clientLevel = (IClientLevelWrapper)level;
                ClientApi.INSTANCE.waitingChunkByClientLevelAndPos.replace(new Pair<IClientLevelWrapper, DhChunkPos>(clientLevel, chunkWrapper.getChunkPos()), chunkWrapper);
            }
            return;
        }
        if (!updateNeighborChunks) {
            SharedApi.bakeChunkLightingAndSendToLevelAsync(chunkWrapper, null, dhLevel);
        } else {
            ArrayList<IChunkWrapper> neighbourChunkList = new ArrayList<IChunkWrapper>(9);
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    if (xOffset == 0 && zOffset == 0) {
                        neighbourChunkList.add(chunkWrapper);
                        continue;
                    }
                    DhChunkPos neighbourPos = new DhChunkPos(chunkWrapper.getChunkPos().x + xOffset, chunkWrapper.getChunkPos().z + zOffset);
                    IChunkWrapper neighbourChunk = dhLevel.getLevelWrapper().tryGetChunk(neighbourPos);
                    if (neighbourChunk == null) continue;
                    neighbourChunkList.add(neighbourChunk);
                }
            }
            for (IChunkWrapper litChunk : neighbourChunkList) {
                SharedApi.bakeChunkLightingAndSendToLevelAsync(litChunk, neighbourChunkList, dhLevel);
            }
        }
    }

    private static void bakeChunkLightingAndSendToLevelAsync(IChunkWrapper chunkWrapper, @Nullable ArrayList<IChunkWrapper> neighbourChunkList, IDhLevel dhLevel) {
        if (UPDATING_CHUNK_SET.size() >= 100 * Config.Client.Advanced.MultiThreading.numberOfLodBuilderThreads.get()) {
            return;
        }
        if (UPDATING_CHUNK_SET.contains(chunkWrapper.getChunkPos())) {
            return;
        }
        UPDATING_CHUNK_SET.add(chunkWrapper.getChunkPos());
        ThreadPoolExecutor executor = ThreadPools.getLightPopulatorExecutor();
        if (executor == null) {
            return;
        }
        executor.execute(() -> {
            block14: {
                LOGGER.trace(chunkWrapper.getChunkPos() + " " + executor.getActiveCount() + " / " + executor.getQueue().size() + " - " + executor.getCompletedTaskCount());
                try {
                    boolean onlyUseDhLighting = Config.Client.Advanced.LodBuilding.onlyUseDhLightingEngine.get();
                    if (!onlyUseDhLighting && chunkWrapper.isLightCorrect()) {
                        try {
                            chunkWrapper.bakeDhLightingUsingMcLightingEngine();
                        }
                        catch (IllegalStateException e) {
                            LOGGER.warn("Chunk light baking error: " + e.getMessage(), (Throwable)e);
                        }
                    } else {
                        ArrayList<IChunkWrapper> nearbyChunkList;
                        if (neighbourChunkList != null) {
                            nearbyChunkList = neighbourChunkList;
                        } else {
                            nearbyChunkList = new ArrayList<IChunkWrapper>(1);
                            nearbyChunkList.add(chunkWrapper);
                        }
                        DhLightingEngine.INSTANCE.lightChunk(chunkWrapper, nearbyChunkList, dhLevel.hasSkyLight() ? 15 : 0);
                    }
                    dhLevel.updateChunkAsync(chunkWrapper);
                    int updateTimeoutInSec = Config.Client.Advanced.LodBuilding.minTimeBetweenChunkUpdatesInSeconds.get();
                    if (updateTimeoutInSec != 0) {
                        CHUNK_UPDATE_TIMER.schedule(new TimerTask(chunkWrapper){
                            final /* synthetic */ IChunkWrapper val$chunkWrapper;
                            {
                                this.val$chunkWrapper = iChunkWrapper;
                            }

                            @Override
                            public void run() {
                                UPDATING_CHUNK_SET.remove(this.val$chunkWrapper.getChunkPos());
                            }
                        }, (long)updateTimeoutInSec * 1000L);
                        break block14;
                    }
                    UPDATING_CHUNK_SET.remove(chunkWrapper.getChunkPos());
                }
                catch (Exception e) {
                    try {
                        LOGGER.error("Unexpected error when updating chunk at pos: [" + chunkWrapper.getChunkPos() + "]", (Throwable)e);
                        int updateTimeoutInSec = Config.Client.Advanced.LodBuilding.minTimeBetweenChunkUpdatesInSeconds.get();
                        if (updateTimeoutInSec != 0) {
                            CHUNK_UPDATE_TIMER.schedule(new /* invalid duplicate definition of identical inner class */, (long)updateTimeoutInSec * 1000L);
                        }
                        UPDATING_CHUNK_SET.remove(chunkWrapper.getChunkPos());
                    }
                    catch (Throwable throwable) {
                        int updateTimeoutInSec = Config.Client.Advanced.LodBuilding.minTimeBetweenChunkUpdatesInSeconds.get();
                        if (updateTimeoutInSec != 0) {
                            CHUNK_UPDATE_TIMER.schedule(new /* invalid duplicate definition of identical inner class */, (long)updateTimeoutInSec * 1000L);
                        } else {
                            UPDATING_CHUNK_SET.remove(chunkWrapper.getChunkPos());
                        }
                        throw throwable;
                    }
                }
            }
        });
    }

    static {
        lastWorldGenTickDelta = 0;
        CHUNK_UPDATE_TIMER = new Timer();
    }
}

