/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData.loader;

import com.google.common.collect.HashMultimap;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataMetaFile;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractFullDataSourceLoader {
    public static final HashMultimap<Class<? extends IFullDataSource>, AbstractFullDataSourceLoader> LOADER_REGISTRY = HashMultimap.create();
    public static final HashMap<String, Class<? extends IFullDataSource>> DATATYPE_REGISTRY = new HashMap();
    public final Class<? extends IFullDataSource> fullDataSourceClass;
    public final String datatype;
    public final byte[] loaderSupportedVersions;
    private final ArrayList<IFullDataSource> cachedSources = new ArrayList();
    private final ReentrantLock cacheLock = new ReentrantLock();

    public AbstractFullDataSourceLoader(Class<? extends IFullDataSource> fullDataSourceClass, String datatype, byte[] loaderSupportedVersions) {
        this.datatype = datatype;
        this.loaderSupportedVersions = loaderSupportedVersions;
        Arrays.sort(loaderSupportedVersions);
        this.fullDataSourceClass = fullDataSourceClass;
        if (DATATYPE_REGISTRY.containsKey(datatype) && DATATYPE_REGISTRY.get(datatype) != fullDataSourceClass) {
            throw new IllegalArgumentException("Loader for datatype: [" + datatype + "] already registered with different class: " + DATATYPE_REGISTRY.get(datatype) + " != " + fullDataSourceClass);
        }
        Set loaders = LOADER_REGISTRY.get(fullDataSourceClass);
        if (loaders.stream().anyMatch(other -> {
            for (byte otherVer : other.loaderSupportedVersions) {
                if (Arrays.binarySearch(loaderSupportedVersions, otherVer) < 0) continue;
                return true;
            }
            return false;
        })) {
            throw new IllegalArgumentException("Loader for class " + fullDataSourceClass + " that supports one of the version in " + Arrays.toString(loaderSupportedVersions) + " already registered!");
        }
        DATATYPE_REGISTRY.put(datatype, fullDataSourceClass);
        LOADER_REGISTRY.put(fullDataSourceClass, (Object)this);
    }

    public static AbstractFullDataSourceLoader getLoader(String dataType, byte dataVersion) {
        return LOADER_REGISTRY.get(DATATYPE_REGISTRY.get(dataType)).stream().filter(loader -> Arrays.binarySearch(loader.loaderSupportedVersions, dataVersion) >= 0).findFirst().orElse(null);
    }

    public static AbstractFullDataSourceLoader getLoader(Class<? extends IFullDataSource> clazz, byte dataVersion) {
        return LOADER_REGISTRY.get(clazz).stream().filter(loader -> Arrays.binarySearch(loader.loaderSupportedVersions, dataVersion) >= 0).findFirst().orElse(null);
    }

    protected abstract IFullDataSource createEmptyDataSource(DhSectionPos var1);

    public IFullDataSource loadDataSource(FullDataMetaFile dataFile, DhDataInputStream inputStream, IDhLevel level) throws IOException, InterruptedException {
        IFullDataSource dataSource = this.createEmptyDataSource(dataFile.pos);
        dataSource.populateFromStream(dataFile, inputStream, level);
        return dataSource;
    }

    public IFullDataSource loadTemporaryDataSource(FullDataMetaFile dataFile, DhDataInputStream inputStream, IDhLevel level) throws IOException, InterruptedException {
        IFullDataSource dataSource = this.tryGetPooledSource();
        if (dataSource != null) {
            dataSource.repopulateFromStream(dataFile, inputStream, level);
        } else {
            dataSource = this.loadDataSource(dataFile, inputStream, level);
        }
        return dataSource;
    }

    public IFullDataSource tryGetPooledSource() {
        try {
            this.cacheLock.lock();
            int index = this.cachedSources.size() - 1;
            if (index == -1) {
                IFullDataSource iFullDataSource = null;
                return iFullDataSource;
            }
            IFullDataSource iFullDataSource = this.cachedSources.remove(index);
            return iFullDataSource;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public void returnPooledDataSource(IFullDataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        if (dataSource.getClass() != this.fullDataSourceClass) {
            return;
        }
        if (this.cachedSources.size() > 25) {
            return;
        }
        try {
            this.cacheLock.lock();
            this.cachedSources.add(dataSource);
        }
        finally {
            this.cacheLock.unlock();
        }
    }
}

