/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.api.enums.config.EGpuUploadMethod;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBufferBuilder;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EGLProxyContext;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.AbstractRenderBuffer;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.StatsMap;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.Logger;

public class ColumnRenderBuffer
extends AbstractRenderBuffer {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftClientWrapper minecraftClient = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final long MAX_BUFFER_UPLOAD_TIMEOUT_NANOSECONDS = 1000000L;
    public final DhBlockPos pos;
    public boolean buffersUploaded = false;
    private GLVertexBuffer[] vbos;
    private GLVertexBuffer[] vbosTransparent;
    private final DhSectionPos debugPos;

    public ColumnRenderBuffer(DhBlockPos pos, DhSectionPos debugPos) {
        this.pos = pos;
        this.debugPos = debugPos;
        this.vbos = new GLVertexBuffer[0];
        this.vbosTransparent = new GLVertexBuffer[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadBuffer(LodQuadBuilder builder, EGpuUploadMethod gpuUploadMethod) throws InterruptedException {
        LodUtil.assertTrue(Thread.currentThread().getName().startsWith(ThreadUtil.THREAD_NAME_PREFIX), "Buffer uploading needs to be done on a DH thread to prevent locking up any MC threads.");
        boolean uploadAsync = Config.Client.Advanced.GpuBuffers.gpuUploadAsync.get();
        if (uploadAsync) {
            GLProxy glProxy = GLProxy.getInstance();
            EGLProxyContext oldContext = glProxy.getGlContext();
            glProxy.setGlContext(EGLProxyContext.LOD_BUILDER);
            try {
                this.uploadBuffersUsingUploadMethod(builder, gpuUploadMethod);
            }
            finally {
                glProxy.setGlContext(oldContext);
            }
        }
        CompletableFuture uploadFuture = new CompletableFuture();
        minecraftClient.executeOnRenderThread(() -> {
            try {
                this.uploadBuffersUsingUploadMethod(builder, gpuUploadMethod);
                uploadFuture.complete(null);
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
        });
        try {
            uploadFuture.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            LOGGER.warn("Error uploading builder [" + builder + "] synchronously. Error: " + e.getMessage(), (Throwable)e);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    private void uploadBuffersUsingUploadMethod(LodQuadBuilder builder, EGpuUploadMethod gpuUploadMethod) throws InterruptedException {
        if (gpuUploadMethod.useEarlyMapping) {
            this.uploadBuffersMapped(builder, gpuUploadMethod);
        } else {
            this.uploadBuffersDirect(builder, gpuUploadMethod);
        }
        this.buffersUploaded = true;
    }

    private void uploadBuffersMapped(LodQuadBuilder builder, EGpuUploadMethod method) {
        this.vbos = ColumnRenderBufferBuilder.resizeBuffer(this.vbos, builder.getCurrentNeededOpaqueVertexBufferCount());
        for (int i = 0; i < this.vbos.length; ++i) {
            if (this.vbos[i] != null) continue;
            this.vbos[i] = new GLVertexBuffer(method.useBufferStorage);
        }
        LodQuadBuilder.BufferFiller func = builder.makeOpaqueBufferFiller(method);
        for (GLVertexBuffer vbo : this.vbos) {
            func.fill(vbo);
        }
        this.vbosTransparent = ColumnRenderBufferBuilder.resizeBuffer(this.vbosTransparent, builder.getCurrentNeededTransparentVertexBufferCount());
        for (int i = 0; i < this.vbosTransparent.length; ++i) {
            if (this.vbosTransparent[i] != null) continue;
            this.vbosTransparent[i] = new GLVertexBuffer(method.useBufferStorage);
        }
        LodQuadBuilder.BufferFiller transparentFillerFunc = builder.makeTransparentBufferFiller(method);
        for (GLVertexBuffer vbo : this.vbosTransparent) {
            transparentFillerFunc.fill(vbo);
        }
    }

    private void uploadBuffersDirect(LodQuadBuilder builder, EGpuUploadMethod method) throws InterruptedException {
        this.vbos = ColumnRenderBufferBuilder.resizeBuffer(this.vbos, builder.getCurrentNeededOpaqueVertexBufferCount());
        ColumnRenderBuffer.uploadBuffersDirect(this.vbos, builder.makeOpaqueVertexBuffers(), method);
        this.vbosTransparent = ColumnRenderBufferBuilder.resizeBuffer(this.vbosTransparent, builder.getCurrentNeededTransparentVertexBufferCount());
        ColumnRenderBuffer.uploadBuffersDirect(this.vbosTransparent, builder.makeTransparentVertexBuffers(), method);
    }

    private static void uploadBuffersDirect(GLVertexBuffer[] vbos, Iterator<ByteBuffer> iter, EGpuUploadMethod method) throws InterruptedException {
        long remainingMS = 0L;
        long MBPerMS = Config.Client.Advanced.GpuBuffers.gpuUploadPerMegabyteInMilliseconds.get().intValue();
        int vboIndex = 0;
        while (iter.hasNext()) {
            if (vboIndex >= vbos.length) {
                throw new RuntimeException("Too many vertex buffers!!");
            }
            if (vbos[vboIndex] == null) {
                vbos[vboIndex] = new GLVertexBuffer(method.useBufferStorage);
            }
            GLVertexBuffer vbo = vbos[vboIndex];
            ByteBuffer bb = iter.next();
            int size = bb.limit() - bb.position();
            try {
                vbo.bind();
                vbo.uploadBuffer(bb, size / LodUtil.LOD_VERTEX_FORMAT.getByteSize(), method, FULL_SIZED_BUFFER);
            }
            catch (Exception e) {
                vbos[vboIndex] = null;
                vbo.close();
                LOGGER.error("Failed to upload buffer: ", (Throwable)e);
            }
            if (MBPerMS > 0L && (remainingMS += (long)size * MBPerMS) >= TimeUnit.NANOSECONDS.convert(16L, TimeUnit.MILLISECONDS)) {
                if (remainingMS > 1000000L) {
                    remainingMS = 1000000L;
                }
                Thread.sleep(remainingMS / 1000000L, (int)(remainingMS % 1000000L));
                remainingMS = 0L;
            }
            ++vboIndex;
        }
        if (vboIndex < vbos.length) {
            throw new RuntimeException("Too few vertex buffers!!");
        }
    }

    @Override
    public boolean renderOpaque(LodRenderer renderContext) {
        boolean hasRendered = false;
        renderContext.setupOffset(this.pos);
        for (GLVertexBuffer vbo : this.vbos) {
            if (vbo == null || vbo.getVertexCount() == 0) continue;
            hasRendered = true;
            renderContext.drawVbo(vbo);
        }
        return hasRendered;
    }

    @Override
    public boolean renderTransparent(LodRenderer renderContext) {
        boolean hasRendered = false;
        try {
            renderContext.setupOffset(this.pos);
            for (GLVertexBuffer vbo : this.vbosTransparent) {
                if (vbo == null || vbo.getVertexCount() == 0) continue;
                hasRendered = true;
                renderContext.drawVbo(vbo);
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error("renderContext program doesn't exist for pos: " + this.pos, (Throwable)e);
        }
        return hasRendered;
    }

    public boolean hasNonEmptyBuffers() {
        for (GLVertexBuffer vertexBuffer : this.vbos) {
            if (vertexBuffer == null || vertexBuffer.getSize() == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void debugDumpStats(StatsMap statsMap) {
        statsMap.incStat("RenderBuffers");
        statsMap.incStat("SimpleRenderBuffers");
        for (GLVertexBuffer vertexBuffer : this.vbos) {
            if (vertexBuffer == null) continue;
            statsMap.incStat("VBOs");
            if (vertexBuffer.getSize() == FULL_SIZED_BUFFER) {
                statsMap.incStat("FullsizedVBOs");
            }
            if (vertexBuffer.getSize() == 0) {
                GLProxy.GL_LOGGER.warn("VBO with size 0", new Object[0]);
            }
            statsMap.incBytesStat("TotalUsage", vertexBuffer.getSize());
        }
    }

    @Override
    public void close() {
        this.buffersUploaded = false;
        GLProxy.getInstance().recordOpenGlCall(() -> {
            for (GLVertexBuffer buffer : this.vbos) {
                if (buffer == null) continue;
                buffer.destroy(false);
            }
            for (GLVertexBuffer buffer : this.vbosTransparent) {
                if (buffer == null) continue;
                buffer.destroy(false);
            }
        });
    }
}

