/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.api.enums.rendering.EDebugRendering;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnBox;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;

public class CubicLodTemplate {
    public static void addLodToBuffer(long data, long topData, long bottomData, ColumnArrayView[][] adjColumnViews, byte detailLevel, int offsetPosX, int offsetOosZ, LodQuadBuilder quadBuilder, EDebugRendering debugging, ColumnRenderSource.DebugSourceFlag debugSource) {
        int color;
        DhLodPos blockOffsetPos = new DhLodPos(detailLevel, offsetPosX, offsetOosZ).convertToDetailLevel((byte)0);
        short width = (short)BitShiftUtil.powerOfTwo(detailLevel);
        short x = (short)blockOffsetPos.x;
        short yMin = RenderDataPointUtil.getYMin(data);
        short z = (short)blockOffsetPos.z;
        short ySize = (short)(RenderDataPointUtil.getYMax(data) - yMin);
        if (ySize == 0) {
            return;
        }
        if (ySize < 0) {
            throw new IllegalArgumentException("Negative y size for the data! Data: " + RenderDataPointUtil.toString(data));
        }
        boolean fullBright = false;
        switch (debugging) {
            case OFF: {
                float saturationMultiplier = Config.Client.Advanced.Graphics.AdvancedGraphics.saturationMultiplier.get().floatValue();
                float brightnessMultiplier = Config.Client.Advanced.Graphics.AdvancedGraphics.brightnessMultiplier.get().floatValue();
                if ((double)saturationMultiplier == 1.0 && (double)brightnessMultiplier == 1.0) {
                    color = RenderDataPointUtil.getColor(data);
                    break;
                }
                float[] ahsv = ColorUtil.argbToAhsv(RenderDataPointUtil.getColor(data));
                color = ColorUtil.ahsvToArgb(ahsv[0], ahsv[1], ahsv[2] * saturationMultiplier, ahsv[3] * brightnessMultiplier);
                break;
            }
            case SHOW_DETAIL: {
                color = LodUtil.DEBUG_DETAIL_LEVEL_COLORS[detailLevel];
                fullBright = true;
                break;
            }
            case SHOW_GENMODE: {
                color = LodUtil.DEBUG_DETAIL_LEVEL_COLORS[RenderDataPointUtil.getGenerationMode(data)];
                fullBright = true;
                break;
            }
            case SHOW_OVERLAPPING_QUADS: {
                color = ColorUtil.WHITE;
                fullBright = true;
                break;
            }
            case SHOW_RENDER_SOURCE_FLAG: {
                color = debugSource == null ? ColorUtil.RED : debugSource.color;
                fullBright = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown debug mode: " + (Object)((Object)debugging));
            }
        }
        ColumnBox.addBoxQuadsToBuilder(quadBuilder, width, ySize, width, x, yMin, z, color, RenderDataPointUtil.getLightSky(data), fullBright ? (byte)15 : (byte)RenderDataPointUtil.getLightBlock(data), topData, bottomData, adjColumnViews);
    }
}

