/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.seibel.distanthorizons.api.enums.config.EGLErrorHandlingMode;
import com.seibel.distanthorizons.api.enums.config.EGlProfileMode;
import com.seibel.distanthorizons.api.enums.config.EGpuUploadMethod;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EGLProxyContext;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.ReflectionUtil;
import com.seibel.distanthorizons.core.util.objects.GLMessage;
import com.seibel.distanthorizons.core.util.objects.GLMessageOutputStream;
import com.seibel.distanthorizons.core.util.objects.Pair;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.coreapi.util.StringUtil;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLUtil;

public class GLProxy {
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private ExecutorService workerThread = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(GLProxy.class.getSimpleName() + "-Worker-Thread").build());
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    public static final ConfigBasedLogger GL_LOGGER = new ConfigBasedLogger(LogManager.getLogger(GLProxy.class), () -> Config.Client.Advanced.Logging.logRendererGLEvent.get());
    private static final ArrayList<Pair<Integer, Integer>> SUPPORTED_GL_VERSIONS = new ArrayList<Pair>(Arrays.asList(new Pair<Integer, Integer>(4, 6), new Pair<Integer, Integer>(4, 5), new Pair<Integer, Integer>(4, 4), new Pair<Integer, Integer>(4, 3), new Pair<Integer, Integer>(4, 2), new Pair<Integer, Integer>(4, 1), new Pair<Integer, Integer>(4, 0), new Pair<Integer, Integer>(3, 3), new Pair<Integer, Integer>(3, 2)));
    private static GLProxy instance = null;
    public final long minecraftGlContext;
    public final GLCapabilities minecraftGlCapabilities;
    public final long lodBuilderGlContext;
    public final GLCapabilities lodBuilderGlCapabilities;
    public final long proxyWorkerGlContext;
    public final GLCapabilities proxyWorkerGlCapabilities;
    public boolean namedObjectSupported = false;
    public boolean bufferStorageSupported = false;
    public boolean VertexAttributeBufferBindingSupported = false;
    private final EGpuUploadMethod preferredUploadMethod;
    public final GLMessage.Builder vanillaDebugMessageBuilder = GLMessage.Builder.DEFAULT_MESSAGE_BUILDER;
    public final GLMessage.Builder lodBuilderDebugMessageBuilder = GLMessage.Builder.DEFAULT_MESSAGE_BUILDER;
    public final GLMessage.Builder proxyWorkerDebugMessageBuilder = GLMessage.Builder.DEFAULT_MESSAGE_BUILDER;

    private GLProxy() throws IllegalStateException {
        String vendor;
        GL_LOGGER.info("Creating " + GLProxy.class.getSimpleName() + "... If this is the last message you see there must have been an OpenGL error.", new Object[0]);
        GL_LOGGER.info("Lod Render OpenGL version [" + GL32.glGetString((int)7938) + "].", new Object[0]);
        if (GLFW.glfwGetCurrentContext() == 0L) {
            throw new IllegalStateException(GLProxy.class.getSimpleName() + " was created outside the render thread!");
        }
        this.minecraftGlContext = GLFW.glfwGetCurrentContext();
        this.minecraftGlCapabilities = GL.getCapabilities();
        if (!this.minecraftGlCapabilities.OpenGL32) {
            String supportedVersionInfo = this.getFailedVersionInfo(this.minecraftGlCapabilities);
            String errorMessage = "Distant Horizons was initializing " + GLProxy.class.getSimpleName() + " and discovered this GPU doesn't meet the OpenGL requirements. Sorry I couldn't tell you sooner :(\nAdditional info:\n" + supportedVersionInfo;
            MC.crashMinecraft(errorMessage, new UnsupportedOperationException("Distant Horizon OpenGL requirements not met"));
        }
        GL_LOGGER.info("minecraftGlCapabilities:\n" + this.versionInfoToString(this.minecraftGlCapabilities), new Object[0]);
        if (Config.Client.Advanced.Debugging.OpenGl.overrideVanillaGLLogger.get().booleanValue()) {
            GLUtil.setupDebugMessageCallback((PrintStream)new PrintStream(new GLMessageOutputStream(GLProxy::logMessage, this.vanillaDebugMessageBuilder), true));
        }
        String contextCreateErrorMessage = "";
        long potentialLodBuilderGlContext = 0L;
        GLCapabilities potentialLodBuilderGlCapabilities = null;
        int majorGlVersion = Config.Client.Advanced.Debugging.OpenGl.glContextMajorVersion.get();
        int minorGlVersion = Config.Client.Advanced.Debugging.OpenGl.glContextMinorVersion.get();
        ArrayList<Pair<Integer, Integer>> glVersions = new ArrayList<Pair<Integer, Integer>>();
        if (majorGlVersion != 0) {
            glVersions.add(new Pair<Integer, Integer>(majorGlVersion, minorGlVersion));
        } else {
            glVersions.addAll(SUPPORTED_GL_VERSIONS);
        }
        for (Pair pair : glVersions) {
            int profileModeInt;
            int glMajorVersion = (Integer)pair.first;
            int glMinorVersion = (Integer)pair.second;
            GL_LOGGER.info("Attempting to create a context with GL version: [" + glMajorVersion + "." + glMinorVersion + "]", new Object[0]);
            GLFW.glfwMakeContextCurrent((long)0L);
            GLFW.glfwDefaultWindowHints();
            GLFW.glfwWindowHint((int)131076, (int)0);
            boolean debugContextEnabled = Config.Client.Advanced.Debugging.OpenGl.enableGlDebugContext.get();
            boolean forwardCompatEnabled = Config.Client.Advanced.Debugging.OpenGl.enableGlForwardCompatibilityMode.get();
            GLFW.glfwWindowHint((int)139266, (int)glMajorVersion);
            GLFW.glfwWindowHint((int)139267, (int)glMinorVersion);
            GLFW.glfwWindowHint((int)139271, (int)(debugContextEnabled ? 1 : 0));
            GLFW.glfwWindowHint((int)139270, (int)(forwardCompatEnabled ? 1 : 0));
            EGlProfileMode profileModeEnum = Config.Client.Advanced.Debugging.OpenGl.glProfileMode.get();
            switch (profileModeEnum) {
                case CORE: {
                    profileModeInt = 204801;
                    break;
                }
                case COMPAT: {
                    profileModeInt = 204802;
                    break;
                }
                default: {
                    profileModeInt = 0;
                }
            }
            GLFW.glfwWindowHint((int)139272, (int)profileModeInt);
            contextCreateErrorMessage = "Failed to create OpenGL GLFW context for OpenGL Version: [" + glMajorVersion + "." + glMinorVersion + "] \nwith Debugging: [" + (debugContextEnabled ? "Enabled" : "Disabled") + "], \nForward Compatibility: [" + "Enabled" + "], \nand Profile: [" + profileModeEnum.name() + "]. ";
            potentialLodBuilderGlContext = GLFW.glfwCreateWindow((int)64, (int)64, (CharSequence)"LOD Builder Window", (long)0L, (long)this.minecraftGlContext);
            if (potentialLodBuilderGlContext == 0L) {
                GL_LOGGER.info(contextCreateErrorMessage, new Object[0]);
                GL_LOGGER.debug("Minecraft GL Capabilities:\n [\n" + ReflectionUtil.getAllFieldValuesAsString(this.minecraftGlCapabilities) + "\n]\n", new Object[0]);
                continue;
            }
            GLFW.glfwMakeContextCurrent((long)potentialLodBuilderGlContext);
            GL_LOGGER.info("Successfully created a context with GL version: [" + glMajorVersion + "." + glMinorVersion + "]", new Object[0]);
            potentialLodBuilderGlCapabilities = GL.createCapabilities();
            GL_LOGGER.info("lodBuilderGlCapabilities:\n" + this.versionInfoToString(potentialLodBuilderGlCapabilities), new Object[0]);
            GLUtil.setupDebugMessageCallback((PrintStream)new PrintStream(new GLMessageOutputStream(GLProxy::logMessage, this.lodBuilderDebugMessageBuilder), true));
            GLFW.glfwMakeContextCurrent((long)0L);
            break;
        }
        if (potentialLodBuilderGlContext == 0L) {
            throw new UnsupportedOperationException("ERROR: Unable to create a GL Context using any of the supported GL versions: [" + StringUtil.join(",", SUPPORTED_GL_VERSIONS) + "]");
        }
        this.lodBuilderGlContext = potentialLodBuilderGlContext;
        this.lodBuilderGlCapabilities = potentialLodBuilderGlCapabilities;
        this.proxyWorkerGlContext = GLFW.glfwCreateWindow((int)64, (int)48, (CharSequence)"LOD proxy worker Window", (long)0L, (long)this.minecraftGlContext);
        if (this.proxyWorkerGlContext == 0L) {
            GL_LOGGER.error(contextCreateErrorMessage + "\n Your OS and GPU Driver may have not support this combination.", new Object[0]);
            GL_LOGGER.error("Minecraft GL Capabilities:\n [\n" + ReflectionUtil.getAllFieldValuesAsString(this.minecraftGlCapabilities) + "\n]\n", new Object[0]);
            throw new UnsupportedOperationException("Forward Compat Core Profile 3.2 creation failure");
        }
        GLFW.glfwMakeContextCurrent((long)this.proxyWorkerGlContext);
        this.proxyWorkerGlCapabilities = GL.createCapabilities();
        GL_LOGGER.info("proxyWorkerGlCapabilities:\n" + this.versionInfoToString(this.lodBuilderGlCapabilities), new Object[0]);
        GLUtil.setupDebugMessageCallback((PrintStream)new PrintStream(new GLMessageOutputStream(GLProxy::logMessage, this.proxyWorkerDebugMessageBuilder), true));
        GLFW.glfwMakeContextCurrent((long)0L);
        this.setGlContext(EGLProxyContext.LOD_BUILDER);
        this.VertexAttributeBufferBindingSupported = this.minecraftGlCapabilities.glBindVertexBuffer != 0L;
        this.namedObjectSupported = this.minecraftGlCapabilities.glNamedBufferData != 0L;
        boolean bl = this.bufferStorageSupported = this.minecraftGlCapabilities.glBufferStorage != 0L && this.lodBuilderGlCapabilities.glBufferStorage != 0L;
        if (!this.bufferStorageSupported) {
            GL_LOGGER.warn("This GPU doesn't support Buffer Storage (OpenGL 4.4), falling back to using other methods.", new Object[0]);
        }
        this.preferredUploadMethod = (vendor = GL32.glGetString((int)7936).toUpperCase()).contains("NVIDIA") || vendor.contains("GEFORCE") ? (this.bufferStorageSupported ? EGpuUploadMethod.BUFFER_STORAGE : EGpuUploadMethod.SUB_DATA) : (this.bufferStorageSupported ? EGpuUploadMethod.BUFFER_STORAGE : EGpuUploadMethod.DATA);
        GL_LOGGER.info("GPU Vendor [" + vendor + "], Preferred upload method is [" + (Object)((Object)this.preferredUploadMethod) + "].", new Object[0]);
        this.setGlContext(EGLProxyContext.MINECRAFT);
        GL_LOGGER.info(GLProxy.class.getSimpleName() + " creation successful. OpenGL smiles upon you this day.", new Object[0]);
    }

    public void setGlContext(EGLProxyContext newContext) {
        long contextPointer;
        EGLProxyContext currentContext = this.getGlContext();
        if (currentContext == newContext) {
            return;
        }
        GLCapabilities newGlCapabilities = null;
        switch (newContext) {
            case LOD_BUILDER: {
                contextPointer = this.lodBuilderGlContext;
                newGlCapabilities = this.lodBuilderGlCapabilities;
                break;
            }
            case MINECRAFT: {
                contextPointer = this.minecraftGlContext;
                newGlCapabilities = this.minecraftGlCapabilities;
                break;
            }
            case PROXY_WORKER: {
                contextPointer = this.proxyWorkerGlContext;
                newGlCapabilities = this.proxyWorkerGlCapabilities;
                break;
            }
            default: {
                contextPointer = 0L;
            }
        }
        GLFW.glfwMakeContextCurrent((long)contextPointer);
        GL.setCapabilities((GLCapabilities)newGlCapabilities);
    }

    public EGLProxyContext getGlContext() {
        long currentContext = GLFW.glfwGetCurrentContext();
        if (currentContext == this.lodBuilderGlContext) {
            return EGLProxyContext.LOD_BUILDER;
        }
        if (currentContext == this.minecraftGlContext) {
            return EGLProxyContext.MINECRAFT;
        }
        if (currentContext == this.proxyWorkerGlContext) {
            return EGLProxyContext.PROXY_WORKER;
        }
        if (currentContext == 0L) {
            return EGLProxyContext.NONE;
        }
        throw new IllegalStateException(Thread.currentThread().getName() + " has a unknown OpenGl context: [" + currentContext + "]. Minecraft context [" + this.minecraftGlContext + "], LodBuilder context [" + this.lodBuilderGlContext + "], ProxyWorker context [" + this.proxyWorkerGlContext + "], no context [0].");
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static GLProxy getInstance() {
        if (instance == null) {
            instance = new GLProxy();
        }
        return instance;
    }

    public EGpuUploadMethod getGpuUploadMethod() {
        EGpuUploadMethod method = Config.Client.Advanced.GpuBuffers.gpuUploadMethod.get();
        if (!this.bufferStorageSupported && method == EGpuUploadMethod.BUFFER_STORAGE) {
            method = EGpuUploadMethod.DATA;
        }
        return method == EGpuUploadMethod.AUTO ? this.preferredUploadMethod : method;
    }

    public void recordOpenGlCall(Runnable renderCall) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        this.workerThread.execute(() -> this.runnableContainer(renderCall, stackTrace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runnableContainer(Runnable renderCall, StackTraceElement[] stackTrace) {
        try {
            this.setGlContext(EGLProxyContext.PROXY_WORKER);
            renderCall.run();
        }
        catch (Exception e) {
            RuntimeException error = new RuntimeException("Uncaught Exception during execution:", e);
            error.setStackTrace(stackTrace);
            GL_LOGGER.error(Thread.currentThread().getName() + " ran into a issue: ", error);
        }
        finally {
            this.setGlContext(EGLProxyContext.NONE);
        }
    }

    public static void ensureAllGLJobCompleted() {
        if (!GLProxy.hasInstance()) {
            return;
        }
        LOGGER.info("Blocking until GL jobs finished...");
        try {
            GLProxy.instance.workerThread.shutdown();
            boolean worked = GLProxy.instance.workerThread.awaitTermination(30L, TimeUnit.SECONDS);
            if (!worked) {
                LOGGER.error("GLWorkerThread shutdown timed out! Game may crash on exit due to cleanup failure!");
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("GLWorkerThread shutdown is interrupted! Game may crash on exit due to cleanup failure!");
            e.printStackTrace();
        }
        finally {
            GLProxy.instance.workerThread = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(GLProxy.class.getSimpleName() + "-Worker-Thread").build());
        }
        LOGGER.info("All GL jobs finished!");
    }

    private static void logMessage(GLMessage msg) {
        EGLErrorHandlingMode errorHandlingMode = Config.Client.Advanced.Debugging.OpenGl.glErrorHandlingMode.get();
        if (errorHandlingMode == EGLErrorHandlingMode.IGNORE) {
            return;
        }
        if (msg.type == GLMessage.EType.ERROR || msg.type == GLMessage.EType.UNDEFINED_BEHAVIOR) {
            GL_LOGGER.error("GL ERROR " + msg.id + " from " + (Object)((Object)msg.source) + ": " + msg.message, new Object[0]);
            if (errorHandlingMode == EGLErrorHandlingMode.LOG_THROW) {
                throw new RuntimeException("GL ERROR: " + msg);
            }
        } else {
            GLMessage.ESeverity severity = msg.severity;
            RuntimeException ex = new RuntimeException("GL MESSAGE: " + msg);
            if (severity == null) {
                severity = GLMessage.ESeverity.LOW;
            }
            switch (severity) {
                case HIGH: {
                    GL_LOGGER.error("{}", ex);
                    break;
                }
                case MEDIUM: {
                    GL_LOGGER.warn("{}", ex);
                    break;
                }
                case LOW: {
                    GL_LOGGER.info("{}", ex);
                    break;
                }
                case NOTIFICATION: {
                    GL_LOGGER.debug("{}", ex);
                }
            }
        }
    }

    private String getFailedVersionInfo(GLCapabilities c) {
        return "Your OpenGL support:\nopenGL version 3.2+: [" + c.OpenGL32 + "] <- REQUIRED\nVertex Attribute Buffer Binding: [" + (c.glVertexAttribBinding != 0L) + "] <- optional improvement\nBuffer Storage: [" + (c.glBufferStorage != 0L) + "] <- optional improvement\nIf you noticed that your computer supports higher OpenGL versions but not the required version, try running the game in compatibility mode. (How you turn that on, I have no clue~)";
    }

    private String versionInfoToString(GLCapabilities c) {
        return "Your OpenGL support:\nopenGL version 3.2+: [" + c.OpenGL32 + "] <- REQUIRED\nVertex Attribute Buffer Binding: [" + (c.glVertexAttribBinding != 0L) + "] <- optional improvement\nBuffer Storage: [" + (c.glBufferStorage != 0L) + "] <- optional improvement\n";
    }
}

