/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.sql.DatabaseUpdater;
import com.seibel.distanthorizons.core.sql.DbConnectionClosedException;
import com.seibel.distanthorizons.core.sql.IBaseDTO;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public abstract class AbstractDhRepo<TDTO extends IBaseDTO> {
    public static final int TIMEOUT_SECONDS = 30;
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final HashMap<String, Connection> CONNECTIONS_BY_CONNECTION_STRING = new HashMap();
    private static final HashMap<AbstractDhRepo<?>, String> ACTIVE_CONNECTION_STRINGS_BY_REPO = new HashMap();
    private final String connectionString;
    private final Connection connection;
    public final String databaseType;
    public final String databaseLocation;
    public final Class<? extends TDTO> dtoClass;

    public AbstractDhRepo(String databaseType, String databaseLocation, Class<? extends TDTO> dtoClass) throws SQLException {
        this.databaseType = databaseType;
        this.databaseLocation = databaseLocation;
        this.dtoClass = dtoClass;
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.connectionString = this.databaseType + ":" + this.databaseLocation;
        if (!CONNECTIONS_BY_CONNECTION_STRING.containsKey(this.connectionString)) {
            Connection connection = DriverManager.getConnection(this.connectionString);
            CONNECTIONS_BY_CONNECTION_STRING.put(this.connectionString, connection);
        }
        this.connection = CONNECTIONS_BY_CONNECTION_STRING.get(this.connectionString);
        ACTIVE_CONNECTION_STRINGS_BY_REPO.put(this, this.connectionString);
        DatabaseUpdater.runAutoUpdateScripts(this);
    }

    public TDTO get(TDTO dto) {
        return this.getByPrimaryKey(dto.getPrimaryKeyString());
    }

    public TDTO getByPrimaryKey(String primaryKey) {
        Map<String, Object> objectMap = this.queryDictionaryFirst(this.createSelectPrimaryKeySql(primaryKey));
        if (objectMap != null && !objectMap.isEmpty()) {
            return this.convertDictionaryToDto(objectMap);
        }
        return null;
    }

    public void save(TDTO dto) {
        if (this.getByPrimaryKey(dto.getPrimaryKeyString()) != null) {
            this.update(dto);
        } else {
            this.insert(dto);
        }
    }

    private void insert(TDTO dto) {
        try (PreparedStatement statement2 = this.createInsertStatement(dto);){
            this.query(statement2);
        }
        catch (DbConnectionClosedException statement2) {
        }
        catch (SQLException e) {
            String message = "Unexpected insert statement error: [" + e.getMessage() + "].";
            LOGGER.error(message);
            throw new RuntimeException(message, e);
        }
    }

    private void update(TDTO dto) {
        try (PreparedStatement statement2 = this.createUpdateStatement(dto);){
            this.query(statement2);
        }
        catch (DbConnectionClosedException statement2) {
        }
        catch (SQLException e) {
            String message = "Unexpected update statement error: [" + e.getMessage() + "].";
            LOGGER.error(message);
            throw new RuntimeException(message, e);
        }
    }

    public void delete(TDTO dto) {
        this.deleteByPrimaryKey(dto.getPrimaryKeyString());
    }

    public void deleteByPrimaryKey(String primaryKey) {
        String whereEqualStatement = this.createWherePrimaryKeySql(primaryKey);
        this.queryDictionaryFirst("DELETE FROM " + this.getTableName() + " WHERE " + whereEqualStatement);
    }

    public void deleteAll() {
        this.queryDictionaryFirst("DELETE FROM " + this.getTableName());
    }

    public boolean exists(TDTO dto) {
        return this.existsWithPrimaryKey(dto.getPrimaryKeyString());
    }

    public boolean existsWithPrimaryKey(String primaryKey) {
        String whereEqualStatement = this.createWherePrimaryKeySql(primaryKey);
        Map<String, Object> result = this.queryDictionaryFirst("SELECT EXISTS(SELECT 1 FROM " + this.getTableName() + " WHERE " + whereEqualStatement + ") as 'existingCount';");
        return result != null && (Integer)result.get("existingCount") != 0;
    }

    public List<Map<String, Object>> queryDictionary(String sql) {
        try {
            return this.query(sql);
        }
        catch (DbConnectionClosedException e) {
            return new ArrayList<Map<String, Object>>();
        }
    }

    @Nullable
    public Map<String, Object> queryDictionaryFirst(String sql) {
        try {
            List<Map<String, Object>> objectList = this.query(sql);
            return !objectList.isEmpty() ? objectList.get(0) : null;
        }
        catch (DbConnectionClosedException e) {
            return null;
        }
    }

    private List<Map<String, Object>> query(PreparedStatement statement) throws RuntimeException, DbConnectionClosedException {
        List<Map<String, Object>> list;
        block9: {
            statement.setQueryTimeout(30);
            boolean resultSetPresent = statement.execute();
            ResultSet resultSet = statement.getResultSet();
            try {
                list = this.parseQueryResult(resultSet, resultSetPresent);
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    if (e.toString().equals("database connection closed")) {
                        throw new DbConnectionClosedException(e);
                    }
                    String message = "Unexpected Query error: [" + e.getMessage() + "], for prepared statement: [" + statement + "].";
                    LOGGER.error(message);
                    throw new RuntimeException(message, e);
                }
            }
            resultSet.close();
        }
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Map<String, Object>> query(String sql) throws RuntimeException, DbConnectionClosedException {
        try (Statement statement = this.connection.createStatement();){
            List<Map<String, Object>> list;
            block15: {
                statement.setQueryTimeout(30);
                boolean resultSetPresent = statement.execute(sql);
                ResultSet resultSet = statement.getResultSet();
                try {
                    list = this.parseQueryResult(resultSet, resultSetPresent);
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return list;
        }
        catch (SQLException e) {
            if (e.toString().equals("database connection closed")) {
                throw new DbConnectionClosedException(e);
            }
            String message = "Unexpected Query error: [" + e.getMessage() + "], for script: [" + sql + "].";
            LOGGER.error(message);
            throw new RuntimeException(message, e);
        }
    }

    private List<Map<String, Object>> parseQueryResult(ResultSet resultSet, boolean resultSetPresent) throws SQLException {
        if (resultSetPresent) {
            List<Map<String, Object>> resultList = AbstractDhRepo.convertResultSetToDictionaryList(resultSet);
            resultSet.close();
            return resultList;
        }
        if (resultSet != null) {
            resultSet.close();
        }
        return new ArrayList<Map<String, Object>>();
    }

    public PreparedStatement createPreparedStatement(String sql) {
        try {
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setQueryTimeout(30);
            return statement;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isConnected() {
        try {
            return this.connection != null && this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public void close() {
        try {
            ACTIVE_CONNECTION_STRINGS_BY_REPO.remove(this);
            if (!ACTIVE_CONNECTION_STRINGS_BY_REPO.containsValue(this.connectionString)) {
                if (this.connection != null) {
                    CONNECTIONS_BY_CONNECTION_STRING.remove(this.connectionString);
                    this.connection.close();
                }
                ACTIVE_CONNECTION_STRINGS_BY_REPO.remove(this);
            }
        }
        catch (SQLException e) {
            Assert.fail((String)("Unable to close the connection: " + e.getMessage()));
        }
    }

    public String createWherePrimaryKeySql(TDTO dto) {
        return this.createWherePrimaryKeySql(dto.getPrimaryKeyString());
    }

    public String createWherePrimaryKeySql(String primaryKeyValue) {
        return this.getPrimaryKeyName() + " = '" + primaryKeyValue + "'";
    }

    public static List<Map<String, Object>> convertResultSetToDictionaryList(ResultSet resultSet) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData resultMetaData = resultSet.getMetaData();
        int resultColumnCount = resultMetaData.getColumnCount();
        while (resultSet.next()) {
            HashMap<String, Object> object = new HashMap<String, Object>();
            for (int columnIndex = 1; columnIndex <= resultColumnCount; ++columnIndex) {
                Object columnValue;
                String columnType;
                String columnName = resultMetaData.getColumnName(columnIndex);
                if (columnName == null || columnName.equals("")) {
                    throw new RuntimeException("SQL result set is missing a column name for column [" + resultMetaData.getTableName(columnIndex) + "." + columnIndex + "].");
                }
                switch (columnType = resultMetaData.getColumnTypeName(columnIndex).toUpperCase()) {
                    case "BIGINT": {
                        columnValue = resultSet.getLong(columnIndex);
                        break;
                    }
                    case "SMALLINT": {
                        columnValue = resultSet.getShort(columnIndex);
                        break;
                    }
                    case "TINYINT": {
                        columnValue = resultSet.getByte(columnIndex);
                        break;
                    }
                    default: {
                        columnValue = resultSet.getObject(columnIndex);
                    }
                }
                object.put(columnName, columnValue);
            }
            list.add(object);
        }
        return list;
    }

    public abstract String getTableName();

    public abstract String getPrimaryKeyName();

    @Nullable
    public abstract TDTO convertDictionaryToDto(Map<String, Object> var1) throws ClassCastException;

    public abstract String createSelectPrimaryKeySql(String var1);

    public abstract PreparedStatement createInsertStatement(TDTO var1) throws SQLException;

    public abstract PreparedStatement createUpdateStatement(TDTO var1) throws SQLException;
}

