/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.sql.AbstractDhRepo;
import com.seibel.distanthorizons.core.sql.IBaseDTO;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import org.apache.logging.log4j.Logger;

public class DatabaseUpdater {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final String SCHEMA_TABLE_NAME = "Schema";
    public static final String UPDATE_SCRIPT_BATCH_SEPARATOR = "--batch--";
    private static final String SQL_SCRIPT_RESOURCE_FOLDER = "sqlScripts/";
    private static final String SQL_SCRIPT_LIST_FILE = "sqlScripts/scriptList.txt";

    public static <TDTO extends IBaseDTO> void runAutoUpdateScripts(AbstractDhRepo<TDTO> repo) throws SQLException {
        ArrayList<SqlScript> scriptList;
        try {
            scriptList = DatabaseUpdater.getAutoUpdateScripts();
        }
        catch (IOException e) {
            LOGGER.error("Get auto update SQL scripts failed. Error: " + e.getMessage(), (Throwable)e);
            return;
        }
        Map<String, Object> schemaTableExistsResult = repo.queryDictionaryFirst("SELECT COUNT(name) as 'tableCount' FROM sqlite_master WHERE type='table' AND name='Schema';");
        if (schemaTableExistsResult == null || (Integer)schemaTableExistsResult.get("tableCount") == 0) {
            String createBaseSchemaTable = "CREATE TABLE Schema ( \n    SchemaVersionId INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \n    ScriptName TEXT NOT NULL UNIQUE, \n    AppliedDateTime DATETIME NOT NULL default CURRENT_TIMESTAMP \n)";
            repo.queryDictionaryFirst(createBaseSchemaTable);
        }
        for (SqlScript resource : scriptList) {
            Map<String, Object> scriptAlreadyRunResult = repo.queryDictionaryFirst("SELECT EXISTS(SELECT 1 FROM Schema WHERE ScriptName='" + resource.name + "') as 'existingCount';");
            if (scriptAlreadyRunResult == null || (Integer)scriptAlreadyRunResult.get("existingCount") != 0) continue;
            LOGGER.info("Running SQL update script: [" + resource.name + "], for repo: [" + repo.databaseLocation + "]");
            int sqlIndex = 0;
            try {
                String[] fileUpdateSqlArray = resource.queryString.split(UPDATE_SCRIPT_BATCH_SEPARATOR);
                Connection connection = repo.getConnection();
                try (Statement statement = connection.createStatement();){
                    for (String updateSql : fileUpdateSqlArray) {
                        statement.addBatch(updateSql);
                    }
                    statement.setQueryTimeout(30);
                    int[] numberOfRowsModifiedArray = statement.executeBatch();
                    while (sqlIndex < numberOfRowsModifiedArray.length) {
                        int numberOfRowsModified = numberOfRowsModifiedArray[sqlIndex];
                        if (numberOfRowsModified < 0) {
                            if (numberOfRowsModified == -3) {
                                LOGGER.error("Execute failed for auto update script: [" + resource.name + "], query: [" + fileUpdateSqlArray[sqlIndex] + "]. Changes have been rolled back.", (Throwable)new SQLException());
                            } else if (numberOfRowsModified == -2) {
                                LOGGER.error("Execute failed for auto update script: [" + resource.name + "], query: [" + fileUpdateSqlArray[sqlIndex] + "]. Changes may not have been rolled back.", (Throwable)new SQLException());
                            } else {
                                LOGGER.error("Unexpected error state [" + numberOfRowsModified + "] returned for auto update script: [" + resource.name + "], query: [" + fileUpdateSqlArray[sqlIndex] + "].", (Throwable)new SQLException());
                            }
                        }
                        ++sqlIndex;
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("Unexpected SQL Error: [" + e.getMessage() + "] returned for auto update script: [" + resource.name + "], query: [" + fileUpdateSqlArray[sqlIndex] + "].", (Throwable)new SQLException());
                    throw e;
                }
            }
            catch (RuntimeException e) {
                LOGGER.error("Unexpected error running database update script [" + resource.name + "] on database [" + repo.databaseLocation + "], stopping database update. Database reading/writing may fail if you continue. \nError: [" + e.getMessage() + "]. \nSql Script:[" + resource.queryString + "]", (Throwable)e);
                throw e;
            }
            repo.queryDictionaryFirst("INSERT INTO Schema (ScriptName) VALUES('" + resource.name + "');");
        }
    }

    private static ArrayList<SqlScript> getAutoUpdateScripts() throws NullPointerException, IOException {
        String[] sqlScriptNames;
        String scriptListString;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try (InputStream scriptListInputStream = loader.getResourceAsStream(SQL_SCRIPT_LIST_FILE);){
            if (scriptListInputStream == null) {
                throw new NullPointerException("Failed to find the SQL Script list file [sqlScripts/scriptList.txt], no auto update scripts can be run.");
            }
            try (Scanner scanner = new Scanner(scriptListInputStream).useDelimiter("\\A");){
                scriptListString = scanner.hasNext() ? scanner.next() : "";
            }
        }
        ArrayList<SqlScript> scriptList = new ArrayList<SqlScript>();
        for (String scriptName : sqlScriptNames = scriptListString.split("\n")) {
            if ((scriptName = scriptName.trim()).isEmpty()) continue;
            scriptName = SQL_SCRIPT_RESOURCE_FOLDER + scriptName.trim();
            try (InputStream scriptInputStream = loader.getResourceAsStream(scriptName);){
                if (scriptInputStream == null) {
                    throw new NullPointerException("Failed to find the SQL Script file [" + scriptName + "], no auto update scripts can be run.");
                }
                try (Scanner fileScanner = new Scanner(scriptInputStream).useDelimiter("\\A");){
                    scriptListString = fileScanner.hasNext() ? fileScanner.next() : "";
                }
                scriptList.add(new SqlScript(scriptName, scriptListString));
            }
        }
        return scriptList;
    }

    private static class SqlScript {
        public String name;
        public String queryString;

        public SqlScript(String name, String queryString) {
            this.name = name;
            this.queryString = queryString;
        }
    }
}

