/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.gridList;

import com.seibel.distanthorizons.core.pos.Pos2D;
import com.seibel.distanthorizons.core.util.LodUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class MovableGridRingList<T>
extends ArrayList<T>
implements List<T> {
    private final AtomicReference<Pos2D> minPosRef = new AtomicReference();
    private final int width;
    private final int halfWidth;
    private final ReentrantReadWriteLock moveLock = new ReentrantReadWriteLock();
    private Pos2D[] ringPositionIteratorArray = null;

    public MovableGridRingList(int halfWidth, Pos2D center) {
        this(halfWidth, center.x, center.y);
    }

    public MovableGridRingList(int halfWidth, int centerX, int centerY) {
        super((halfWidth * 2 + 1) * (halfWidth * 2 + 1));
        this.width = halfWidth * 2 + 1;
        this.halfWidth = halfWidth;
        this.minPosRef.set(new Pos2D(centerX - halfWidth, centerY - halfWidth));
        this.clear();
    }

    public T get(Pos2D pos) {
        return this.get(pos.x, pos.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int x, int y) {
        Pos2D min = this.minPosRef.get();
        if (!this._inRangeAcquired(x, y, min)) {
            return null;
        }
        this.moveLock.readLock().lock();
        try {
            Pos2D newMin = this.minPosRef.get();
            if (min != newMin && !this._inRangeAcquired(x, y, newMin)) {
                T t = null;
                return t;
            }
            T t = this._getUnsafe(x, y);
            return t;
        }
        finally {
            this.moveLock.readLock().unlock();
        }
    }

    public boolean set(Pos2D pos, T item) {
        return this.set(pos.x, pos.y, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(int x, int y, T item) {
        Pos2D min = this.minPosRef.get();
        if (!this._inRangeAcquired(x, y, min)) {
            return false;
        }
        this.moveLock.readLock().lock();
        try {
            Pos2D newMin = this.minPosRef.get();
            if (min != newMin && !this._inRangeAcquired(x, y, newMin)) {
                boolean bl = false;
                return bl;
            }
            this._setUnsafe(x, y, item);
            boolean bl = true;
            return bl;
        }
        finally {
            this.moveLock.readLock().unlock();
        }
    }

    public T setChained(Pos2D pos, T item) {
        return this.setChained(pos.x, pos.y, item);
    }

    public T setChained(int x, int y, T item) {
        return (T)(this.set(x, y, item) ? item : null);
    }

    public T swap(Pos2D pos, T item) {
        return this.swap(pos.x, pos.y, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T swap(int x, int y, T item) {
        Pos2D min = this.minPosRef.get();
        if (!this._inRangeAcquired(x, y, min)) {
            return item;
        }
        this.moveLock.readLock().lock();
        try {
            Pos2D newMin = this.minPosRef.get();
            if (min != newMin && !this._inRangeAcquired(x, y, newMin)) {
                T t = item;
                return t;
            }
            T t = this._swapUnsafe(x, y, item);
            return t;
        }
        finally {
            this.moveLock.readLock().unlock();
        }
    }

    public T remove(Pos2D pos) {
        return this.remove(pos.x, pos.y);
    }

    public T remove(int x, int y) {
        return this.swap(x, y, null);
    }

    @Override
    public void clear() {
        this.clear(null);
    }

    public void clear(Consumer<? super T> removedItemConsumer) {
        this.moveLock.writeLock().lock();
        try {
            if (removedItemConsumer != null) {
                super.forEach((? super E item) -> {
                    if (item != null) {
                        removedItemConsumer.accept(item);
                    }
                });
            }
            super.clear();
            super.ensureCapacity(this.width * this.width);
            for (int i = 0; i < this.width * this.width; ++i) {
                super.add(null);
            }
        }
        finally {
            this.moveLock.writeLock().unlock();
        }
    }

    public boolean moveTo(int newCenterX, int newCenterY) {
        return this.moveTo(newCenterX, newCenterY, null);
    }

    public boolean moveTo(int newCenterX, int newCenterY, Consumer<? super T> removedItemConsumer) {
        return this.moveTo(newCenterX, newCenterY, removedItemConsumer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveTo(int newCenterX, int newCenterY, Consumer<? super T> removedItemConsumer, BiConsumer<Pos2D, ? super T> nullableRemovedItemConsumer) {
        Pos2D cPos = this.minPosRef.get();
        int newMinX = newCenterX - this.halfWidth;
        int newMinY = newCenterY - this.halfWidth;
        if (cPos.x == newMinX && cPos.y == newMinY) {
            return false;
        }
        this.moveLock.writeLock().lock();
        try {
            cPos = this.minPosRef.get();
            int deltaX = newMinX - cPos.x;
            int deltaY = newMinY - cPos.y;
            if (deltaX == 0 && deltaY == 0) {
                boolean bl = false;
                return bl;
            }
            if (Math.abs(deltaX) >= this.width || Math.abs(deltaY) >= this.width) {
                this.clear(removedItemConsumer);
            } else {
                for (int x = 0; x < this.width; ++x) {
                    for (int y = 0; y < this.width; ++y) {
                        Pos2D itemPos = new Pos2D(x + cPos.x, y + cPos.y);
                        if (x - deltaX < 0 || y - deltaY < 0 || x - deltaX >= this.width || y - deltaY >= this.width) {
                            Object item = this._swapUnsafe(itemPos.x, itemPos.y, null);
                            if (item != null && removedItemConsumer != null) {
                                removedItemConsumer.accept(item);
                            }
                            if (nullableRemovedItemConsumer == null) continue;
                            nullableRemovedItemConsumer.accept(itemPos, (Pos2D)item);
                            continue;
                        }
                        if (nullableRemovedItemConsumer == null) continue;
                        nullableRemovedItemConsumer.accept(itemPos, null);
                    }
                }
            }
            this.minPosRef.set(new Pos2D(newMinX, newMinY));
            boolean bl = true;
            return bl;
        }
        finally {
            this.moveLock.writeLock().unlock();
        }
    }

    public Pos2D getCenter() {
        return new Pos2D(this.minPosRef.get().x + this.halfWidth, this.minPosRef.get().y + this.halfWidth);
    }

    public Pos2D getMinPosInRange() {
        return this.minPosRef.get();
    }

    public Pos2D getMaxPosInRange() {
        return new Pos2D(this.minPosRef.get().x + this.width - 1, this.minPosRef.get().y + this.width - 1);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHalfWidth() {
        return this.halfWidth;
    }

    public boolean inRange(int x, int y) {
        Pos2D minPos = this.minPosRef.get();
        return x >= minPos.x && x < minPos.x + this.width && y >= minPos.y && y < minPos.y + this.width;
    }

    private boolean _inRangeAcquired(int x, int y, Pos2D min) {
        return x >= min.x && x < min.x + this.width && y >= min.y && y < min.y + this.width;
    }

    private T _getUnsafe(int x, int y) {
        return (T)super.get(Math.floorMod(x, this.width) + Math.floorMod(y, this.width) * this.width);
    }

    private void _setUnsafe(int x, int y, T item) {
        super.set(Math.floorMod(x, this.width) + Math.floorMod(y, this.width) * this.width, item);
    }

    private T _swapUnsafe(int x, int y, T item) {
        return super.set(Math.floorMod(x, this.width) + Math.floorMod(y, this.width) * this.width, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachPos(BiConsumer<? super T, Pos2D> consumer) {
        this.moveLock.readLock().lock();
        try {
            Pos2D min = this.minPosRef.get();
            for (int x = min.x; x < min.x + this.width; ++x) {
                for (int y = min.y; y < min.y + this.width; ++y) {
                    T t = this._getUnsafe(x, y);
                    consumer.accept(t, new Pos2D(x, y));
                }
            }
        }
        finally {
            this.moveLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachOrdered(Consumer<? super T> consumer) {
        if (this.ringPositionIteratorArray == null) {
            this.createRingIteratorList();
        }
        this.moveLock.readLock().lock();
        try {
            Pos2D min = this.minPosRef.get();
            for (Pos2D offset : this.ringPositionIteratorArray) {
                T item = this._getUnsafe(min.x + offset.x, min.y + offset.y);
                if (item == null) continue;
                consumer.accept(item);
            }
        }
        finally {
            this.moveLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachPosOrdered(BiConsumer<? super T, Pos2D> consumer) {
        if (this.ringPositionIteratorArray == null) {
            this.createRingIteratorList();
        }
        this.moveLock.readLock().lock();
        try {
            Pos2D min = this.minPosRef.get();
            for (Pos2D offset : this.ringPositionIteratorArray) {
                LodUtil.assertTrue(this._inRangeAcquired(min.x + offset.x, min.y + offset.y, min));
                T item = this._getUnsafe(min.x + offset.x, min.y + offset.y);
                consumer.accept(item, new Pos2D(min.x + offset.x, min.y + offset.y));
            }
        }
        finally {
            this.moveLock.readLock().unlock();
        }
    }

    private void createRingIteratorList() {
        this.ringPositionIteratorArray = null;
        Pos2D[] posArray = new Pos2D[this.width * this.width];
        int i = 0;
        for (int xPos = -this.halfWidth; xPos <= this.halfWidth; ++xPos) {
            for (int zPos = -this.halfWidth; zPos <= this.halfWidth; ++zPos) {
                posArray[i] = new Pos2D(xPos, zPos);
                ++i;
            }
        }
        Arrays.sort(posArray, (a, b) -> {
            long disSqrA = (long)a.x * (long)a.x + (long)a.y * (long)a.y;
            long disSqrB = (long)b.x * (long)b.x + (long)b.y * (long)b.y;
            return Double.compare(disSqrA, disSqrB);
        });
        for (int j = 0; j < posArray.length; ++j) {
            posArray[j] = posArray[j].add(new Pos2D(this.halfWidth, this.halfWidth));
        }
        for (Pos2D pos2D : posArray) {
            LodUtil.assertTrue(pos2D.x >= 0 && pos2D.x < this.width);
            LodUtil.assertTrue(pos2D.y >= 0 && pos2D.y < this.width);
        }
        this.ringPositionIteratorArray = posArray;
    }

    @Override
    public String toString() {
        Pos2D p = this.minPosRef.get();
        return this.getClass().getSimpleName() + "[" + (p.x + this.halfWidth) + "," + (p.y + this.halfWidth) + "] " + this.width + "*" + this.width + "[" + this.size() + "]";
    }

    public String toDetailString() {
        StringBuilder str = new StringBuilder("\n");
        int i = 0;
        str.append(this);
        str.append("\n");
        for (Object t : this) {
            str.append(t != null ? t.toString() : "NULL");
            str.append(", ");
            if (++i % this.width != 0) continue;
            str.append("\n");
        }
        return str.toString();
    }
}

