/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.threading;

import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.threading.DhThreadFactory;
import com.seibel.distanthorizons.core.util.threading.RateLimitedThreadPoolExecutor;
import java.util.concurrent.Semaphore;

public class ConfigThreadPool {
    private final Semaphore activeThreadCountSemaphore;
    public RateLimitedThreadPoolExecutor executor = null;
    private int threadCount = 0;
    public final DhThreadFactory threadFactory;
    public final ConfigChangeListener<Integer> threadCountConfigListener;
    public final ConfigEntry<Integer> threadCountConfig;
    public final ConfigEntry<Double> runTimeRatioConfig;

    public int getThreadCount() {
        return this.threadCount;
    }

    public ConfigThreadPool(DhThreadFactory threadFactory, ConfigEntry<Integer> threadCountConfig, ConfigEntry<Double> runTimeRatioConfig, Semaphore activeThreadCountSemaphore) {
        this.threadFactory = threadFactory;
        this.activeThreadCountSemaphore = activeThreadCountSemaphore;
        this.threadCountConfig = threadCountConfig;
        this.threadCountConfigListener = new ConfigChangeListener<Integer>(threadCountConfig, threadCount -> this.setThreadPoolSize((int)threadCount));
        this.runTimeRatioConfig = runTimeRatioConfig;
        this.setThreadPoolSize(threadCountConfig.get());
    }

    public void setThreadPoolSize(int threadPoolSize) {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.threadCount = threadPoolSize;
        this.executor = ThreadUtil.makeRateLimitedThreadPool(this.threadCount, this.threadFactory, this.runTimeRatioConfig, this.activeThreadCountSemaphore);
    }

    public void shutdownExecutorService() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.threadCount = 0;
    }
}

