/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.wrapperInterfaces.chunk;

import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhBlockPos2D;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.coreapi.interfaces.dependencyInjection.IBindable;
import java.util.ArrayList;

public interface IChunkWrapper
extends IBindable {
    public DhChunkPos getChunkPos();

    default public int getHeight() {
        return this.getMaxBuildHeight() - this.getMinBuildHeight();
    }

    public int getMinBuildHeight();

    public int getMaxBuildHeight();

    public int getMinFilledHeight();

    public int getSolidHeightMapValue(int var1, int var2);

    public int getLightBlockingHeightMapValue(int var1, int var2);

    public int getMaxBlockX();

    public int getMaxBlockZ();

    public int getMinBlockX();

    public int getMinBlockZ();

    public long getLongChunkPos();

    public void setIsDhLightCorrect(boolean var1);

    public void setUseDhLighting(boolean var1);

    public boolean isLightCorrect();

    public int getDhSkyLight(int var1, int var2, int var3);

    public void setDhSkyLight(int var1, int var2, int var3, int var4);

    public int getDhBlockLight(int var1, int var2, int var3);

    public void setDhBlockLight(int var1, int var2, int var3, int var4);

    public int getBlockLight(int var1, int var2, int var3);

    public int getSkyLight(int var1, int var2, int var3);

    default public void bakeDhLightingUsingMcLightingEngine() throws IllegalStateException {
        if (!this.isLightCorrect()) {
            throw new IllegalStateException("Unable to bake lighting for for chunk [" + this.getChunkPos() + "], Minecraft lighting not valid.");
        }
        for (int relX = 0; relX < 16; ++relX) {
            for (int relZ = 0; relZ < 16; ++relZ) {
                for (int y = this.getMinBuildHeight(); y < this.getMaxBuildHeight(); ++y) {
                    this.setDhSkyLight(relX, y, relZ, this.getSkyLight(relX, y, relZ));
                    this.setDhBlockLight(relX, y, relZ, this.getBlockLight(relX, y, relZ));
                }
            }
        }
        this.setIsDhLightCorrect(true);
        this.setUseDhLighting(true);
    }

    public ArrayList<DhBlockPos> getBlockLightPosList();

    default public boolean blockPosInsideChunk(DhBlockPos blockPos) {
        return this.blockPosInsideChunk(blockPos.x, blockPos.y, blockPos.z);
    }

    default public boolean blockPosInsideChunk(int x, int y, int z) {
        return x >= this.getMinBlockX() && x <= this.getMaxBlockX() && y >= this.getMinBuildHeight() && y < this.getMaxBuildHeight() && z >= this.getMinBlockZ() && z <= this.getMaxBlockZ();
    }

    default public boolean blockPosInsideChunk(DhBlockPos2D blockPos) {
        return blockPos.x >= this.getMinBlockX() && blockPos.x <= this.getMaxBlockX() && blockPos.z >= this.getMinBlockZ() && blockPos.z <= this.getMaxBlockZ();
    }

    public boolean doNearbyChunksExist();

    public String toString();

    default public int roughHashCode() {
        int hash = 31;
        int primeMultiplier = 227;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                hash = hash * primeMultiplier + Integer.hashCode(this.getLightBlockingHeightMapValue(x, z));
            }
        }
        return hash;
    }

    default public IBlockStateWrapper getBlockState(DhBlockPos pos) {
        return this.getBlockState(pos.x, pos.y, pos.z);
    }

    public IBlockStateWrapper getBlockState(int var1, int var2, int var3);

    public IBiomeWrapper getBiome(int var1, int var2, int var3);

    public boolean isStillValid();
}

