/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers;

import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.coreapi.util.math.Mat4f;
import java.nio.FloatBuffer;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1159;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class McObjectConverter {
    static final class_2350[] directions;
    static final EDhDirection[] lodDirections;

    private static int bufferIndex(int x, int y) {
        return y * 4 + x;
    }

    private static void storeMatrix(class_1159 matrix, FloatBuffer buffer) {
        matrix.method_4932(buffer);
    }

    public static Mat4f Convert(class_1159 mcMatrix) {
        FloatBuffer buffer = FloatBuffer.allocate(16);
        McObjectConverter.storeMatrix(mcMatrix, buffer);
        Mat4f matrix = new Mat4f(buffer);
        matrix.transpose();
        return matrix;
    }

    public static class_2338 Convert(DhBlockPos wrappedPos) {
        return new class_2338(wrappedPos.x, wrappedPos.y, wrappedPos.z);
    }

    public static class_1923 Convert(DhChunkPos wrappedPos) {
        return new class_1923(wrappedPos.x, wrappedPos.z);
    }

    public static class_2350 Convert(EDhDirection lodDirection) {
        return directions[lodDirection.ordinal()];
    }

    public static EDhDirection Convert(class_2350 direction) {
        return lodDirections[direction.ordinal()];
    }

    public static void DebugCheckAllPackers() {
        BiConsumer<Integer, Integer> func = (x, z) -> DhChunkPos._DebugCheckPacker(x, z, class_1923.method_8331((int)x, (int)z));
        func.accept(0, 0);
        func.accept(12345, 134);
        func.accept(-12345, -134);
        func.accept(-1875000, 1875000);
        func.accept(1875000, -1875000);
        func.accept(1875000, 1875000);
        func.accept(-1875000, -1875000);
        Consumer<class_2338> func2 = p -> DhBlockPos._DebugCheckPacker(p.method_10263(), p.method_10264(), p.method_10260(), p.method_10063());
        func2.accept(new class_2338(0, 0, 0));
        func2.accept(new class_2338(12345, 134, 123));
        func2.accept(new class_2338(-12345, -134, -80));
        func2.accept(new class_2338(-30000000, 2047, 30000000));
        func2.accept(new class_2338(30000000, -2048, -30000000));
        func2.accept(new class_2338(30000000, 2047, 30000000));
        func2.accept(new class_2338(-30000000, -2048, -30000000));
    }

    static {
        EDhDirection[] lodDirs = EDhDirection.values();
        directions = new class_2350[lodDirs.length];
        lodDirections = new EDhDirection[lodDirs.length];
        for (EDhDirection lodDir : lodDirs) {
            class_2350 dir = switch (lodDir.name().toUpperCase()) {
                case "DOWN" -> class_2350.field_11033;
                case "UP" -> class_2350.field_11036;
                case "NORTH" -> class_2350.field_11043;
                case "SOUTH" -> class_2350.field_11035;
                case "WEST" -> class_2350.field_11039;
                case "EAST" -> class_2350.field_11034;
                default -> null;
            };
            if (dir == null) {
                throw new IllegalArgumentException("Invalid direction on init mapping: " + lodDir);
            }
            McObjectConverter.directions[lodDir.ordinal()] = dir;
            McObjectConverter.lodDirections[dir.ordinal()] = lodDir;
        }
    }
}

