/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers;

import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.worldGeneration.AbstractBatchGenerationEnvironmentWrapper;
import java.io.IOException;
import java.util.HashSet;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;

public class WrapperFactory
implements IWrapperFactory {
    public static final WrapperFactory INSTANCE = new WrapperFactory();

    @Override
    public AbstractBatchGenerationEnvironmentWrapper createBatchGenerator(IDhLevel targetLevel) {
        if (targetLevel instanceof IDhServerLevel) {
            return new BatchGenerationEnvironment((IDhServerLevel)targetLevel);
        }
        throw new IllegalArgumentException("The target level must be a server-side level.");
    }

    @Override
    public IBiomeWrapper deserializeBiomeWrapper(String str, ILevelWrapper levelWrapper) throws IOException {
        return BiomeWrapper.deserialize(str, levelWrapper);
    }

    @Override
    public IBlockStateWrapper deserializeBlockStateWrapper(String str, ILevelWrapper levelWrapper) throws IOException {
        return BlockStateWrapper.deserialize(str, levelWrapper);
    }

    @Override
    public IBlockStateWrapper getAirBlockStateWrapper() {
        return BlockStateWrapper.AIR;
    }

    @Override
    public HashSet<IBlockStateWrapper> getRendererIgnoredBlocks(ILevelWrapper levelWrapper) {
        return BlockStateWrapper.getRendererIgnoredBlocks(levelWrapper);
    }

    @Override
    public IChunkWrapper createChunkWrapper(Object[] objectArray) throws ClassCastException {
        if (objectArray.length == 1 && objectArray[0] instanceof IChunkWrapper) {
            try {
                return (IChunkWrapper)objectArray[0];
            }
            catch (Exception e) {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
        }
        if (objectArray.length == 2) {
            ILevelWrapper levelWrapper;
            Level level;
            if (!(objectArray[0] instanceof ChunkAccess)) {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
            ChunkAccess chunk = (ChunkAccess)objectArray[0];
            if (!(objectArray[1] instanceof Level)) {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
            Level lightSource = level = (Level)objectArray[1];
            if (level instanceof ServerLevel) {
                levelWrapper = ServerLevelWrapper.getWrapper((ServerLevel)level);
            } else if (level instanceof ClientLevel) {
                levelWrapper = ClientLevelWrapper.getWrapper((ClientLevel)level);
            } else {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
            return new ChunkWrapper(chunk, (LevelReader)lightSource, levelWrapper);
        }
        throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
    }

    private static String createChunkWrapperErrorMessage(Object[] objectArray) {
        StringBuilder message = new StringBuilder("Chunk wrapper creation failed. \nExpected parameters: \n");
        message.append("[" + ChunkAccess.class.getName() + "], \n");
        message.append("[" + ServerLevel.class.getName() + "] or [" + ClientLevel.class.getName() + "]. \n");
        if (objectArray.length != 0) {
            message.append("Given parameters: ");
            for (Object obj : objectArray) {
                message.append("[").append(obj.getClass().getName()).append("], ");
            }
        } else {
            message.append(" No parameters given.");
        }
        return message.toString();
    }
}

