/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.mojang.blaze3d.platform.NativeImage;
import com.seibel.distanthorizons.api.enums.config.ELodShading;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.UUID;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.minecraft.ProfilerWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MinecraftClientWrapper
implements IMinecraftClientWrapper,
IMinecraftSharedWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    public static final MinecraftClientWrapper INSTANCE = new MinecraftClientWrapper();
    public final Minecraft mc = Minecraft.m_91087_();
    private NativeImage lightMap = null;
    private ProfilerWrapper profilerWrapper;

    private MinecraftClientWrapper() {
    }

    @Override
    public void clearFrameObjectCache() {
        this.lightMap = null;
    }

    @Override
    public float getShade(EDhDirection lodDirection) {
        ELodShading lodShading = Config.Client.Advanced.Graphics.AdvancedGraphics.lodShading.get();
        switch (lodShading) {
            default: {
                if (this.mc.f_91073_ != null) {
                    Direction mcDir = McObjectConverter.Convert(lodDirection);
                    return this.mc.f_91073_.m_7717_(mcDir, true);
                }
                return 0.0f;
            }
            case OLD_LIGHTING: {
                switch (lodDirection) {
                    case DOWN: {
                        return 0.5f;
                    }
                    default: {
                        return 1.0f;
                    }
                    case NORTH: 
                    case SOUTH: {
                        return 0.8f;
                    }
                    case WEST: 
                    case EAST: 
                }
                return 0.6f;
            }
            case NONE: 
        }
        return 1.0f;
    }

    @Override
    public boolean hasSinglePlayerServer() {
        return this.mc.m_91091_();
    }

    @Override
    public boolean clientConnectedToDedicatedServer() {
        return this.mc.m_91089_() != null && !this.hasSinglePlayerServer();
    }

    @Override
    public String getCurrentServerName() {
        return this.mc.m_91089_().f_105362_;
    }

    @Override
    public String getCurrentServerIp() {
        return this.mc.m_91089_().f_105363_;
    }

    @Override
    public String getCurrentServerVersion() {
        return this.mc.m_91089_().f_105368_.getString();
    }

    public LocalPlayer getPlayer() {
        return this.mc.f_91074_;
    }

    @Override
    public boolean playerExists() {
        return this.mc.f_91074_ != null;
    }

    @Override
    public UUID getPlayerUUID() {
        return this.getPlayer().m_20148_();
    }

    @Override
    public DhBlockPos getPlayerBlockPos() {
        BlockPos playerPos = this.getPlayer().m_20183_();
        return new DhBlockPos(playerPos.m_123341_(), playerPos.m_123342_(), playerPos.m_123343_());
    }

    @Override
    public DhChunkPos getPlayerChunkPos() {
        ChunkPos playerPos = this.getPlayer().m_146902_();
        return new DhChunkPos(playerPos.f_45578_, playerPos.f_45579_);
    }

    public ModelManager getModelManager() {
        return this.mc.m_91304_();
    }

    @Override
    @Nullable
    public IClientLevelWrapper getWrappedClientLevel() {
        if (this.mc.f_91073_ == null) {
            return null;
        }
        return ClientLevelWrapper.getWrapperIgnoringOverride(this.mc.f_91073_);
    }

    @Override
    @Deprecated
    public File getGameDirectory() {
        return this.getInstallationDirectory();
    }

    @Override
    public IProfilerWrapper getProfiler() {
        if (this.profilerWrapper == null) {
            this.profilerWrapper = new ProfilerWrapper(this.mc.m_91307_());
        } else if (this.mc.m_91307_() != this.profilerWrapper.profiler) {
            this.profilerWrapper.profiler = this.mc.m_91307_();
        }
        return this.profilerWrapper;
    }

    @Override
    public ArrayList<ILevelWrapper> getAllServerWorlds() {
        ArrayList<ILevelWrapper> worlds = new ArrayList<ILevelWrapper>();
        Iterable serverWorlds = this.mc.m_91092_().m_129785_();
        for (ServerLevel world : serverWorlds) {
            worlds.add(ServerLevelWrapper.getWrapper(world));
        }
        return worlds;
    }

    @Override
    public void sendChatMessage(String string) {
        LocalPlayer p = this.getPlayer();
        if (p == null) {
            return;
        }
        p.m_213846_((Component)Component.m_237115_((String)string));
    }

    @Override
    public void crashMinecraft(String errorMessage, Throwable exception) {
        LOGGER.error("Distant Horizons had the following error: [" + errorMessage + "]. Crashing Minecraft...", exception);
        CrashReport report = new CrashReport(errorMessage, exception);
        Minecraft.m_91332_((CrashReport)report);
    }

    @Override
    public Object getOptionsObject() {
        return this.mc.f_91066_;
    }

    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public File getInstallationDirectory() {
        return this.mc.f_91069_;
    }

    @Override
    public void executeOnRenderThread(Runnable runnable) {
        this.mc.execute(runnable);
    }
}

