/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration;

import com.google.common.collect.ImmutableMap;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.transformers.FullDataToRenderDataTransformer;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.ConfigBasedSpamLogger;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.gridList.ArrayGridList;
import com.seibel.distanthorizons.core.util.objects.EventTimer;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.worldGeneration.AbstractBatchGenerationEnvironmentWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.DependencySetupDoneCheck;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.GenerationEvent;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.GlobalParameters;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.Rolling;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.ChunkLoader;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DhLitWorldGenRegion;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DummyLightEngine;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.LightGetterAdaptor;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.RegionFileStorageExternalCache;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepBiomes;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepFeatures;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepNoise;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepStructureReference;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepStructureStart;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepSurface;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import org.apache.logging.log4j.LogManager;

public final class BatchGenerationEnvironment
extends AbstractBatchGenerationEnvironmentWrapper {
    public static final ConfigBasedSpamLogger PREF_LOGGER = new ConfigBasedSpamLogger(LogManager.getLogger((String)"LodWorldGen"), () -> Config.Client.Advanced.Logging.logWorldGenPerformance.get(), 1);
    public static final ConfigBasedLogger EVENT_LOGGER = new ConfigBasedLogger(LogManager.getLogger((String)"LodWorldGen"), () -> Config.Client.Advanced.Logging.logWorldGenEvent.get());
    public static final ConfigBasedLogger LOAD_LOGGER = new ConfigBasedLogger(LogManager.getLogger((String)"LodWorldGen"), () -> Config.Client.Advanced.Logging.logWorldGenLoadEvent.get());
    private final IDhServerLevel serverlevel;
    public final LinkedBlockingQueue<GenerationEvent> generationEventList = new LinkedBlockingQueue();
    public final GlobalParameters params;
    public final StepStructureStart stepStructureStart = new StepStructureStart(this);
    public final StepStructureReference stepStructureReference = new StepStructureReference(this);
    public final StepBiomes stepBiomes = new StepBiomes(this);
    public final StepNoise stepNoise = new StepNoise(this);
    public final StepSurface stepSurface = new StepSurface(this);
    public final StepFeatures stepFeatures = new StepFeatures(this);
    public boolean unsafeThreadingRecorded = false;
    public static final long EXCEPTION_TIMER_RESET_TIME = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    public static final int EXCEPTION_COUNTER_TRIGGER = 20;
    public static final int RANGE_TO_RANGE_EMPTY_EXTENSION = 1;
    public int unknownExceptionCount = 0;
    public long lastExceptionTriggerTime = 0L;
    private AtomicReference<RegionFileStorageExternalCache> regionFileStorageCacheRef = new AtomicReference();
    public static ThreadLocal<Boolean> isDistantGeneratorThread = new ThreadLocal();
    public static ThreadLocal<Object> onDistantGenerationMixinData = new ThreadLocal();
    public static ImmutableMap<EDhApiWorldGenerationStep, Integer> BorderNeeded;
    public static int MaxBorderNeeded;

    public RegionFileStorageExternalCache getOrCreateRegionFileCache(RegionFileStorage storage) {
        RegionFileStorageExternalCache cache = this.regionFileStorageCacheRef.get();
        if (cache == null && !this.regionFileStorageCacheRef.compareAndSet(null, cache = new RegionFileStorageExternalCache(storage))) {
            cache = this.regionFileStorageCacheRef.get();
        }
        return cache;
    }

    public static boolean isCurrentThreadDistantGeneratorThread() {
        return isDistantGeneratorThread.get() != null;
    }

    public static void putDistantGenerationMixinData(Object data) {
        LodUtil.assertTrue(BatchGenerationEnvironment.isCurrentThreadDistantGeneratorThread());
        onDistantGenerationMixinData.set(data);
    }

    public static Object getDistantGenerationMixinData() {
        LodUtil.assertTrue(BatchGenerationEnvironment.isCurrentThreadDistantGeneratorThread());
        return onDistantGenerationMixinData.get();
    }

    public static void clearDistantGenerationMixinData() {
        LodUtil.assertTrue(BatchGenerationEnvironment.isCurrentThreadDistantGeneratorThread());
        onDistantGenerationMixinData.remove();
    }

    public BatchGenerationEnvironment(IDhServerLevel serverlevel) {
        super(serverlevel);
        this.serverlevel = serverlevel;
        EVENT_LOGGER.info("================WORLD_GEN_STEP_INITING=============", new Object[0]);
        serverlevel.getServerLevelWrapper().getDimensionType();
        ChunkGenerator generator = ((ServerLevelWrapper)serverlevel.getServerLevelWrapper()).getLevel().m_7726_().m_8481_();
        if (!(generator instanceof NoiseBasedChunkGenerator || generator instanceof DebugLevelSource || generator instanceof FlatLevelSource)) {
            if (generator.getClass().toString().equals("class com.terraforged.mod.chunk.TFChunkGenerator")) {
                EVENT_LOGGER.info("TerraForge Chunk Generator detected: [" + generator.getClass() + "], Distant Generation will try its best to support it.", new Object[0]);
                EVENT_LOGGER.info("If it does crash, turn Distant Generation off or set it to to [" + EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY + "].", new Object[0]);
            } else if (generator.getClass().toString().equals("class net.dries007.tfc.world.TFCChunkGenerator")) {
                EVENT_LOGGER.info("TerraFirmaCraft Chunk Generator detected: [" + generator.getClass() + "], Distant Generation will try its best to support it.", new Object[0]);
                EVENT_LOGGER.info("If it does crash, turn Distant Generation off or set it to to [" + EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY + "].", new Object[0]);
            } else {
                EVENT_LOGGER.warn("Unknown Chunk Generator detected: [" + generator.getClass() + "], Distant Generation May Fail!", new Object[0]);
                EVENT_LOGGER.warn("If it does crash, disable Distant Generation or set the Generation Mode to [" + EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY + "].", new Object[0]);
            }
        }
        this.params = new GlobalParameters(serverlevel);
    }

    public <T> T joinSync(CompletableFuture<T> future) {
        if (!this.unsafeThreadingRecorded && !future.isDone()) {
            EVENT_LOGGER.error("Unsafe MultiThreading in Chunk Generator: ", new RuntimeException("Concurrent future"));
            EVENT_LOGGER.error("To increase stability, it is recommended to set world generation threads count to 1.", new Object[0]);
            this.unsafeThreadingRecorded = true;
        }
        return future.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAllFutures() {
        if (this.unknownExceptionCount > 0 && System.nanoTime() - this.lastExceptionTriggerTime >= EXCEPTION_TIMER_RESET_TIME) {
            this.unknownExceptionCount = 0;
        }
        Iterator<GenerationEvent> iter = this.generationEventList.iterator();
        while (iter.hasNext()) {
            GenerationEvent event = iter.next();
            if (event.future.isDone()) {
                if (event.future.isCompletedExceptionally() && !event.future.isCancelled()) {
                    try {
                        event.future.get();
                        LodUtil.assertNotReach();
                    }
                    catch (Exception e) {
                        ++this.unknownExceptionCount;
                        this.lastExceptionTriggerTime = System.nanoTime();
                        EVENT_LOGGER.error("Batching World Generator event [" + event + "] threw an exception: " + e.getMessage(), e);
                    }
                }
                iter.remove();
                continue;
            }
            if (!event.hasTimeout(Config.Client.Advanced.WorldGenerator.worldGenerationTimeoutLengthInSeconds.get(), TimeUnit.SECONDS)) continue;
            EVENT_LOGGER.error("Batching World Generator: " + event + " timed out and terminated!", new Object[0]);
            EVENT_LOGGER.info("Dump PrefEvent: " + event.timer, new Object[0]);
            try {
                if (event.terminate()) continue;
                EVENT_LOGGER.error("Failed to terminate the stuck generation event!", new Object[0]);
            }
            finally {
                iter.remove();
            }
        }
        if (this.unknownExceptionCount > 20) {
            EVENT_LOGGER.error("Too many exceptions in Batching World Generator! Disabling the generator.", new Object[0]);
            this.unknownExceptionCount = 0;
            Config.Client.Advanced.WorldGenerator.enableDistantGeneration.set(false);
        }
    }

    private static ProtoChunk EmptyChunk(ServerLevel level, ChunkPos chunkPos) {
        return new ProtoChunk(chunkPos, UpgradeData.f_63320_, (LevelHeightAccessor)level, level.m_5962_().m_175515_(Registry.f_122885_), null);
    }

    public ChunkAccess loadOrMakeChunk(ChunkPos chunkPos) {
        ServerLevel level = this.params.level;
        CompoundTag chunkData = null;
        try {
            RegionFileStorage storage = this.params.level.m_7726_().f_8325_.f_63495_.f_63518_;
            RegionFileStorageExternalCache cache = this.getOrCreateRegionFileCache(storage);
            chunkData = cache.read(chunkPos);
        }
        catch (Exception e) {
            LOAD_LOGGER.error("DistantHorizons: Couldn't load or make chunk " + chunkPos + ". Error: " + e.getMessage(), e);
        }
        if (chunkData == null) {
            return BatchGenerationEnvironment.EmptyChunk(level, chunkPos);
        }
        try {
            LOAD_LOGGER.info("DistantHorizons: Loading chunk " + chunkPos + " from disk.", new Object[0]);
            return ChunkLoader.read((WorldGenLevel)level, chunkPos, chunkData);
        }
        catch (Exception e) {
            LOAD_LOGGER.error("DistantHorizons: Couldn't load or make chunk " + chunkPos + ". Returning an empty chunk. Error: " + e.getMessage(), e);
            return BatchGenerationEnvironment.EmptyChunk(level, chunkPos);
        }
    }

    private static <T> ArrayGridList<T> GetCutoutFrom(ArrayGridList<T> total, int border) {
        return new ArrayGridList<T>(total, border, total.gridSize - border);
    }

    private static <T> ArrayGridList<T> GetCutoutFrom(ArrayGridList<T> total, EDhApiWorldGenerationStep step) {
        return BatchGenerationEnvironment.GetCutoutFrom(total, MaxBorderNeeded - (Integer)BorderNeeded.get((Object)step));
    }

    public void generateLodFromList(GenerationEvent genEvent) throws InterruptedException {
        ArrayGridList<ChunkWrapper> chunkWrapperList;
        EVENT_LOGGER.debug("Lod Generate Event: " + genEvent.minPos, new Object[0]);
        int borderSize = MaxBorderNeeded;
        int refSize = genEvent.size + borderSize * 2;
        int refPosX = genEvent.minPos.x - borderSize;
        int refPosZ = genEvent.minPos.z - borderSize;
        try {
            LightGetterAdaptor adaptor = new LightGetterAdaptor((BlockGetter)this.params.level);
            DummyLightEngine lightEngine = new DummyLightEngine(adaptor);
            EmptyChunkGenerator generator = (x, z) -> {
                ChunkPos chunkPos = new ChunkPos(x, z);
                ChunkAccess target = null;
                try {
                    target = this.loadOrMakeChunk(chunkPos);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (target == null) {
                    target = new ProtoChunk(chunkPos, UpgradeData.f_63320_, (LevelHeightAccessor)this.params.level, this.params.biomes, null);
                }
                return target;
            };
            ArrayGridList<ChunkAccess> totalChunks = new ArrayGridList<ChunkAccess>(refSize, (x, z) -> generator.generate(x + refPosX, z + refPosZ));
            genEvent.refreshTimeout();
            DhLitWorldGenRegion region = new DhLitWorldGenRegion(this.params.level, lightEngine, totalChunks, ChunkStatus.f_62315_, refSize / 2, generator);
            adaptor.setRegion(region);
            genEvent.threadedParam.makeStructFeat((WorldGenLevel)region, this.params);
            chunkWrapperList = new ArrayGridList<ChunkWrapper>(totalChunks.gridSize);
            totalChunks.forEachPos((x, z) -> {
                ChunkAccess chunk = (ChunkAccess)totalChunks.get((int)x, (int)z);
                if (chunk != null) {
                    chunkWrapperList.set((int)x, (int)z, new ChunkWrapper(chunk, (LevelReader)region, this.serverlevel.getLevelWrapper()));
                }
            });
            this.generateDirect(genEvent, chunkWrapperList, borderSize, genEvent.targetGenerationStep, region);
            genEvent.timer.nextEvent("cleanup");
        }
        catch (StepStructureStart.StructStartCorruptedException f) {
            genEvent.threadedParam.markAsInvalid();
            throw (RuntimeException)f.getCause();
        }
        ArrayGridList<ChunkWrapper> finalGenChunks = BatchGenerationEnvironment.GetCutoutFrom(chunkWrapperList, borderSize);
        for (int offsetY = 0; offsetY < finalGenChunks.gridSize; ++offsetY) {
            for (int offsetX = 0; offsetX < finalGenChunks.gridSize; ++offsetX) {
                ChunkWrapper wrappedChunk = finalGenChunks.get(offsetX, offsetY);
                ChunkAccess target = wrappedChunk.getChunk();
                if (target instanceof LevelChunk) {
                    ((LevelChunk)target).f_62775_ = true;
                }
                if (!wrappedChunk.isLightCorrect()) {
                    throw new RuntimeException("The generated chunk somehow has isLightCorrect() returning false");
                }
                boolean isFull = target.m_6415_() == ChunkStatus.f_62326_ || target instanceof LevelChunk;
                boolean isPartial = target.m_187675_();
                if (isFull) {
                    LOAD_LOGGER.info("Detected full existing chunk at {}", target.m_7697_());
                    genEvent.resultConsumer.accept(wrappedChunk);
                    continue;
                }
                if (isPartial) {
                    LOAD_LOGGER.info("Detected old existing chunk at {}", target.m_7697_());
                    genEvent.resultConsumer.accept(wrappedChunk);
                    continue;
                }
                if (target.m_6415_() == ChunkStatus.f_62314_) {
                    genEvent.resultConsumer.accept(wrappedChunk);
                    continue;
                }
                genEvent.resultConsumer.accept(wrappedChunk);
            }
        }
        genEvent.timer.complete();
        genEvent.refreshTimeout();
        if (PREF_LOGGER.canMaybeLog()) {
            genEvent.threadedParam.perf.recordEvent(genEvent.timer);
            PREF_LOGGER.infoInc("{}", genEvent.timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDirect(GenerationEvent genEvent, ArrayGridList<ChunkWrapper> chunksToGenerate, int border, EDhApiWorldGenerationStep step, DhLitWorldGenRegion region) throws InterruptedException {
        block25: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    if (Thread.interrupted()) {
                                        return;
                                    }
                                    chunksToGenerate.forEach(chunkWrapper -> {
                                        ChunkAccess chunk = chunkWrapper.getChunk();
                                        if (chunk instanceof ProtoChunk) {
                                            ProtoChunk protoChunk = (ProtoChunk)chunk;
                                            protoChunk.m_63209_(region.m_5518_());
                                        }
                                    });
                                    if (step != EDhApiWorldGenerationStep.EMPTY) break block19;
                                    genEvent.timer.nextEvent("light");
                                    int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                                    ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>(chunksToGenerate);
                                    for (int i = 0; i < iChunkWrapperList.size(); ++i) {
                                        IChunkWrapper centerChunk = iChunkWrapperList.get(i);
                                        if (centerChunk == null) continue;
                                        BatchGenerationEnvironment.throwIfThreadInterrupted();
                                        Heightmap.m_64256_((ChunkAccess)((ChunkWrapper)centerChunk).getChunk(), (Set)ChunkStatus.f_62322_.m_62500_());
                                        DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
                                    }
                                    genEvent.refreshTimeout();
                                    return;
                                }
                                genEvent.timer.nextEvent("structStart");
                                BatchGenerationEnvironment.throwIfThreadInterrupted();
                                this.stepStructureStart.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunksToGenerate, EDhApiWorldGenerationStep.STRUCTURE_START));
                                genEvent.refreshTimeout();
                                if (step != EDhApiWorldGenerationStep.STRUCTURE_START) break block20;
                                genEvent.timer.nextEvent("light");
                                int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                                ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>(chunksToGenerate);
                                for (int i = 0; i < iChunkWrapperList.size(); ++i) {
                                    IChunkWrapper centerChunk = iChunkWrapperList.get(i);
                                    if (centerChunk == null) continue;
                                    BatchGenerationEnvironment.throwIfThreadInterrupted();
                                    Heightmap.m_64256_((ChunkAccess)((ChunkWrapper)centerChunk).getChunk(), (Set)ChunkStatus.f_62322_.m_62500_());
                                    DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
                                }
                                genEvent.refreshTimeout();
                                return;
                            }
                            genEvent.timer.nextEvent("structRef");
                            BatchGenerationEnvironment.throwIfThreadInterrupted();
                            this.stepStructureReference.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunksToGenerate, EDhApiWorldGenerationStep.STRUCTURE_REFERENCE));
                            genEvent.refreshTimeout();
                            if (step != EDhApiWorldGenerationStep.STRUCTURE_REFERENCE) break block21;
                            genEvent.timer.nextEvent("light");
                            int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                            ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>(chunksToGenerate);
                            for (int i = 0; i < iChunkWrapperList.size(); ++i) {
                                IChunkWrapper centerChunk = iChunkWrapperList.get(i);
                                if (centerChunk == null) continue;
                                BatchGenerationEnvironment.throwIfThreadInterrupted();
                                Heightmap.m_64256_((ChunkAccess)((ChunkWrapper)centerChunk).getChunk(), (Set)ChunkStatus.f_62322_.m_62500_());
                                DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
                            }
                            genEvent.refreshTimeout();
                            return;
                        }
                        genEvent.timer.nextEvent("biome");
                        BatchGenerationEnvironment.throwIfThreadInterrupted();
                        this.stepBiomes.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunksToGenerate, EDhApiWorldGenerationStep.BIOMES));
                        genEvent.refreshTimeout();
                        if (step != EDhApiWorldGenerationStep.BIOMES) break block22;
                        genEvent.timer.nextEvent("light");
                        int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                        ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>(chunksToGenerate);
                        for (int i = 0; i < iChunkWrapperList.size(); ++i) {
                            IChunkWrapper centerChunk = iChunkWrapperList.get(i);
                            if (centerChunk == null) continue;
                            BatchGenerationEnvironment.throwIfThreadInterrupted();
                            Heightmap.m_64256_((ChunkAccess)((ChunkWrapper)centerChunk).getChunk(), (Set)ChunkStatus.f_62322_.m_62500_());
                            DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
                        }
                        genEvent.refreshTimeout();
                        return;
                    }
                    genEvent.timer.nextEvent("noise");
                    BatchGenerationEnvironment.throwIfThreadInterrupted();
                    this.stepNoise.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunksToGenerate, EDhApiWorldGenerationStep.NOISE));
                    genEvent.refreshTimeout();
                    if (step != EDhApiWorldGenerationStep.NOISE) break block23;
                    genEvent.timer.nextEvent("light");
                    int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                    ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>(chunksToGenerate);
                    for (int i = 0; i < iChunkWrapperList.size(); ++i) {
                        IChunkWrapper centerChunk = iChunkWrapperList.get(i);
                        if (centerChunk == null) continue;
                        BatchGenerationEnvironment.throwIfThreadInterrupted();
                        Heightmap.m_64256_((ChunkAccess)((ChunkWrapper)centerChunk).getChunk(), (Set)ChunkStatus.f_62322_.m_62500_());
                        DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
                    }
                    genEvent.refreshTimeout();
                    return;
                }
                genEvent.timer.nextEvent("surface");
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                this.stepSurface.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunksToGenerate, EDhApiWorldGenerationStep.SURFACE));
                genEvent.refreshTimeout();
                if (step != EDhApiWorldGenerationStep.SURFACE) break block24;
                genEvent.timer.nextEvent("light");
                int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>(chunksToGenerate);
                for (int i = 0; i < iChunkWrapperList.size(); ++i) {
                    IChunkWrapper centerChunk = iChunkWrapperList.get(i);
                    if (centerChunk == null) continue;
                    BatchGenerationEnvironment.throwIfThreadInterrupted();
                    Heightmap.m_64256_((ChunkAccess)((ChunkWrapper)centerChunk).getChunk(), (Set)ChunkStatus.f_62322_.m_62500_());
                    DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
                }
                genEvent.refreshTimeout();
                return;
            }
            genEvent.timer.nextEvent("carver");
            BatchGenerationEnvironment.throwIfThreadInterrupted();
            if (step != EDhApiWorldGenerationStep.CARVERS) break block25;
            genEvent.timer.nextEvent("light");
            int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
            ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>(chunksToGenerate);
            for (int i = 0; i < iChunkWrapperList.size(); ++i) {
                IChunkWrapper centerChunk = iChunkWrapperList.get(i);
                if (centerChunk == null) continue;
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                Heightmap.m_64256_((ChunkAccess)((ChunkWrapper)centerChunk).getChunk(), (Set)ChunkStatus.f_62322_.m_62500_());
                DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
            }
            genEvent.refreshTimeout();
            return;
        }
        try {
            genEvent.timer.nextEvent("feature");
            BatchGenerationEnvironment.throwIfThreadInterrupted();
            this.stepFeatures.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunksToGenerate, EDhApiWorldGenerationStep.FEATURES));
            genEvent.refreshTimeout();
            genEvent.timer.nextEvent("light");
        }
        catch (Throwable throwable) {
            genEvent.timer.nextEvent("light");
            int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
            ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>(chunksToGenerate);
            for (int i = 0; i < iChunkWrapperList.size(); ++i) {
                IChunkWrapper centerChunk = iChunkWrapperList.get(i);
                if (centerChunk == null) continue;
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                Heightmap.m_64256_((ChunkAccess)((ChunkWrapper)centerChunk).getChunk(), (Set)ChunkStatus.f_62322_.m_62500_());
                DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
            }
            genEvent.refreshTimeout();
            throw throwable;
        }
        int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
        ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>(chunksToGenerate);
        for (int i = 0; i < iChunkWrapperList.size(); ++i) {
            IChunkWrapper centerChunk = iChunkWrapperList.get(i);
            if (centerChunk == null) continue;
            BatchGenerationEnvironment.throwIfThreadInterrupted();
            Heightmap.m_64256_((ChunkAccess)((ChunkWrapper)centerChunk).getChunk(), (Set)ChunkStatus.f_62322_.m_62500_());
            DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
        }
        genEvent.refreshTimeout();
    }

    @Override
    public int getEventCount() {
        return this.generationEventList.size();
    }

    @Override
    public void stop() {
        EVENT_LOGGER.info(BatchGenerationEnvironment.class.getSimpleName() + " shutting down...", new Object[0]);
        EVENT_LOGGER.info("Canceling in progress generation event futures...", new Object[0]);
        Iterator<GenerationEvent> iter = this.generationEventList.iterator();
        while (iter.hasNext()) {
            GenerationEvent event = iter.next();
            event.future.cancel(true);
            iter.remove();
        }
        RegionFileStorageExternalCache regionStorage = this.regionFileStorageCacheRef.get();
        if (regionStorage != null) {
            try {
                regionStorage.close();
            }
            catch (IOException e) {
                EVENT_LOGGER.error("Failed to close region file storage cache!", e);
            }
        }
        EVENT_LOGGER.info(BatchGenerationEnvironment.class.getSimpleName() + " shutdown complete.", new Object[0]);
    }

    @Override
    public CompletableFuture<Void> generateChunks(int minX, int minZ, int genSize, EDhApiWorldGenerationStep targetStep, ExecutorService worldGeneratorThreadPool, Consumer<IChunkWrapper> resultConsumer) {
        GenerationEvent genEvent = GenerationEvent.startEvent(new DhChunkPos(minX, minZ), genSize, this, targetStep, resultConsumer, worldGeneratorThreadPool);
        this.generationEventList.add(genEvent);
        return genEvent.future;
    }

    public static void throwIfThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException(FullDataToRenderDataTransformer.class.getSimpleName() + " task interrupted.");
        }
    }

    static {
        DependencySetupDoneCheck.getIsCurrentThreadDistantGeneratorThread = BatchGenerationEnvironment::isCurrentThreadDistantGeneratorThread;
        boolean isTerraFirmaCraft = false;
        try {
            Class.forName("net.dries007.tfc.world.TFCChunkGenerator");
            isTerraFirmaCraft = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        EVENT_LOGGER.info("DH TerraFirmaCraft detection: " + isTerraFirmaCraft, new Object[0]);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)EDhApiWorldGenerationStep.EMPTY, (Object)1);
        builder.put((Object)EDhApiWorldGenerationStep.STRUCTURE_START, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.STRUCTURE_REFERENCE, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.BIOMES, (Object)(isTerraFirmaCraft ? 1 : 0));
        builder.put((Object)EDhApiWorldGenerationStep.NOISE, (Object)(isTerraFirmaCraft ? 1 : 0));
        builder.put((Object)EDhApiWorldGenerationStep.SURFACE, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.CARVERS, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.LIQUID_CARVERS, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.FEATURES, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.LIGHT, (Object)0);
        BorderNeeded = builder.build();
        MaxBorderNeeded = BorderNeeded.values().stream().mapToInt(Integer::intValue).max().getAsInt();
    }

    public static interface EmptyChunkGenerator {
        public ChunkAccess generate(int var1, int var2);
    }

    public static class PerfCalculator {
        private static final String[] TIME_NAMES = new String[]{"total", "setup", "structStart", "structRef", "biome", "noise", "surface", "carver", "feature", "light", "cleanup"};
        public static final int SIZE = 50;
        ArrayList<Rolling> times = new ArrayList();

        public PerfCalculator() {
            for (int i = 0; i < 11; ++i) {
                this.times.add(new Rolling(50));
            }
        }

        public void recordEvent(EventTimer event) {
            for (EventTimer.Event e : event.events) {
                String name = e.name;
                int index = Arrays.asList(TIME_NAMES).indexOf(name);
                if (index == -1) continue;
                this.times.get(index).add(e.timeNs);
            }
            this.times.get(0).add(event.getTotalTimeNs());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.times.size(); ++i) {
                if (this.times.get(i).getAverage() == 0.0) continue;
                sb.append(TIME_NAMES[i]).append(": ").append(this.times.get(i).getAverage()).append("\n");
            }
            return sb.toString();
        }
    }
}

