/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.render.entity.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.stream.Collectors;
import ladysnake.illuminations.client.Illuminations;
import ladysnake.illuminations.client.config.Config;
import ladysnake.illuminations.client.data.OverheadData;
import ladysnake.illuminations.client.data.PlayerCosmeticData;
import ladysnake.illuminations.client.render.GlowyRenderLayer;
import ladysnake.illuminations.client.render.entity.model.hat.OverheadModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class OverheadFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final Map<String, ResolvedOverheadData> models = Illuminations.OVERHEADS_DATA.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, data -> new ResolvedOverheadData(((OverheadData)data.getValue()).getTexture(), ((OverheadData)data.getValue()).createModel(loader))));

    public OverheadFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> featureRendererContext, EntityRendererProvider.Context loader) {
        super(featureRendererContext);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        ResolvedOverheadData resolvedOverheadData;
        String playerOverhead;
        PlayerCosmeticData cosmeticData = Illuminations.getCosmeticData((Player)entity);
        if (Config.shouldDisplayCosmetics() && cosmeticData != null && !entity.m_20145_() && (playerOverhead = cosmeticData.getOverhead()) != null && (resolvedOverheadData = this.models.get(playerOverhead)) != null) {
            ResourceLocation texture = resolvedOverheadData.texture();
            OverheadModel model = resolvedOverheadData.model();
            model.head.f_104200_ = ((PlayerModel)this.m_117386_()).f_102808_.f_104200_;
            model.head.f_104201_ = ((PlayerModel)this.m_117386_()).f_102808_.f_104201_;
            model.head.f_104203_ = ((PlayerModel)this.m_117386_()).f_102808_.f_104203_;
            model.head.f_104204_ = ((PlayerModel)this.m_117386_()).f_102808_.f_104204_;
            model.m_7695_(matrices, vertexConsumers.m_6299_(GlowyRenderLayer.get(texture)), 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private record ResolvedOverheadData(ResourceLocation texture, OverheadModel model) {
    }
}

