/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.data;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IExtraService;
import mcp.mobius.waila.api.data.BuiltinDataUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class FluidData
implements IData {
    public static final ResourceLocation ID = BuiltinDataUtil.rl("fluid");
    public static final ResourceLocation CONFIG_DISPLAY_UNIT = BuiltinDataUtil.rl("fluid.display_unit");
    private final List<Entry<?>> entries;
    private final Unit unit;

    @ApiSide.ClientOnly
    public static <T extends Fluid> void describeFluid(T fluid, FluidDescriptor<T> descriptor) {
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            Preconditions.checkArgument((flowing == flowing.m_5613_() ? 1 : 0) != 0, (Object)"Not a source fluid");
        }
        IExtraService.INSTANCE.setFluidDescFor(fluid, descriptor);
    }

    @ApiSide.ClientOnly
    public static <T extends Fluid> void describeFluid(Class<T> clazz, FluidDescriptor<T> descriptor) {
        IExtraService.INSTANCE.setFluidDescFor(clazz, descriptor);
    }

    public static void describeCauldron(Block block, CauldronDescriptor descriptor) {
        IExtraService.INSTANCE.setCauldronDescFor(block, descriptor);
    }

    public static void describeCauldron(Class<? extends Block> clazz, CauldronDescriptor descriptor) {
        IExtraService.INSTANCE.setCauldronDescFor(clazz, descriptor);
    }

    public static FluidData of(Unit unit) {
        return new FluidData(new ArrayList(), unit);
    }

    public static FluidData of(Unit unit, int slotCountHint) {
        return new FluidData(new ArrayList(slotCountHint), unit);
    }

    public FluidData add(Fluid fluid, @Nullable CompoundTag nbt, double stored, double capacity) {
        Fluid fluid2;
        capacity = Math.max(capacity, 0.0);
        stored = Mth.m_14008_((double)stored, (double)0.0, (double)capacity);
        if (capacity == 0.0) {
            capacity = Double.POSITIVE_INFINITY;
        }
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            fluid2 = flowing.m_5613_();
        } else {
            fluid2 = fluid;
        }
        Fluid source = fluid2;
        this.entries.add(new Entry<Fluid>(source, nbt, stored, capacity));
        return this;
    }

    @ApiStatus.Internal
    private FluidData(List<Entry<?>> entries, Unit unit) {
        this.entries = entries;
        this.unit = unit;
    }

    @ApiStatus.Internal
    public FluidData(FriendlyByteBuf buf) {
        this.unit = (Unit)buf.m_130066_(Unit.class);
        int size = buf.m_130242_();
        this.entries = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            if (buf.readBoolean()) continue;
            int id = buf.m_130242_();
            Fluid fluid = (Fluid)Registry.f_122822_.m_7942_(id);
            CompoundTag nbt = buf.m_130260_();
            double stored = buf.readDouble();
            double capacity = buf.readDouble();
            this.add(fluid, nbt, stored, capacity);
        }
    }

    @Override
    @ApiStatus.Internal
    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.unit);
        buf.m_130130_(this.entries.size());
        for (Entry<?> entry : this.entries) {
            if (entry.isEmpty()) {
                buf.writeBoolean(true);
                continue;
            }
            buf.writeBoolean(false);
            buf.m_236818_((IdMap)Registry.f_122822_, entry.fluid);
            buf.m_130079_(entry.nbt);
            buf.writeDouble(entry.stored);
            buf.writeDouble(entry.capacity);
        }
    }

    @ApiStatus.Internal
    public Unit unit() {
        return this.unit;
    }

    @ApiStatus.Internal
    public List<Entry<?>> entries() {
        return this.entries;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.21")
    public static FluidData of() {
        return FluidData.of(Unit.MILLIBUCKETS);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.21")
    public static FluidData of(int slotCountHint) {
        return FluidData.of(Unit.MILLIBUCKETS, slotCountHint);
    }

    @ApiSide.ClientOnly
    @ApiStatus.OverrideOnly
    public static interface FluidDescriptor<T extends Fluid> {
        public void describeFluid(FluidDescriptionContext<T> var1, FluidDescription var2);
    }

    @ApiStatus.OverrideOnly
    public static interface CauldronDescriptor {
        @Nullable
        public FluidData getCauldronFluidData(BlockState var1);
    }

    public static enum Unit {
        MILLIBUCKETS("mB"),
        DROPLETS("dp");

        public final String symbol;

        public static double convert(Unit from, Unit to, double amount) {
            if (from == to) {
                return amount;
            }
            return switch (to) {
                default -> throw new IncompatibleClassChangeError();
                case MILLIBUCKETS -> amount / 81.0;
                case DROPLETS -> amount * 81.0;
            };
        }

        private Unit(String symbol) {
            this.symbol = symbol;
        }
    }

    @ApiStatus.Internal
    public static class Entry<T extends Fluid>
    implements FluidDescriptionContext<T> {
        private final T fluid;
        @Nullable
        private final CompoundTag nbt;
        private final double stored;
        private final double capacity;

        private Entry(T fluid, @Nullable CompoundTag nbt, double stored, double capacity) {
            this.fluid = fluid;
            this.nbt = nbt;
            this.stored = stored;
            this.capacity = capacity;
        }

        public boolean isEmpty() {
            return this.fluid == Fluids.f_76191_ || this.stored <= 0.0;
        }

        @Override
        public T fluid() {
            return this.fluid;
        }

        @Override
        @Nullable
        public CompoundTag nbt() {
            return this.nbt;
        }

        public double stored() {
            return this.stored;
        }

        public double capacity() {
            return this.capacity;
        }
    }

    @ApiSide.ClientOnly
    @ApiStatus.NonExtendable
    public static interface FluidDescriptionContext<T extends Fluid> {
        public T fluid();

        @Nullable
        public CompoundTag nbt();
    }

    @ApiSide.ClientOnly
    @ApiStatus.NonExtendable
    public static interface FluidDescription {
        public FluidDescription name(Component var1);

        public FluidDescription sprite(TextureAtlasSprite var1);

        public FluidDescription tint(int var1);
    }
}

