/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.service.ICommonService;
import mcp.mobius.waila.util.Log;
import mcp.mobius.waila.util.ModInfo;

public abstract class PluginLoader {
    private static final Log LOG = Log.create();
    private static final boolean ENABLE_TEST_PLUGIN = Boolean.getBoolean("waila.enableTestPlugin");
    protected static final String[] PLUGIN_JSON_FILES = new String[]{"waila_plugins.json", "wthit_plugins.json"};
    protected static final String KEY_INITIALIZER = "initializer";
    protected static final String KEY_SIDE = "side";
    protected static final String KEY_REQUIRED = "required";
    protected static final Map<String, IPluginInfo.Side> SIDES = Map.of("client", IPluginInfo.Side.CLIENT, "server", IPluginInfo.Side.SERVER, "both", IPluginInfo.Side.BOTH, "*", IPluginInfo.Side.BOTH);

    protected abstract void gatherPlugins();

    protected void readPluginsJson(String modId, Path path) {
        block13: {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                for (String pluginId : object.keySet()) {
                    IPluginInfo.Side side;
                    JsonObject plugin = object.getAsJsonObject(pluginId);
                    String initializer = plugin.getAsJsonPrimitive(KEY_INITIALIZER).getAsString();
                    IPluginInfo.Side side2 = side = plugin.has(KEY_SIDE) ? Objects.requireNonNull(SIDES.get(plugin.get(KEY_SIDE).getAsString()), () -> PluginLoader.readError(path) + ", invalid side, available: " + SIDES.keySet().stream().collect(Collectors.joining(", ", "[", "]"))) : IPluginInfo.Side.BOTH;
                    if (!side.matches(ICommonService.INSTANCE.getSide())) {
                        break;
                    }
                    ArrayList<String> required = new ArrayList<String>();
                    if (plugin.has(KEY_REQUIRED)) {
                        JsonArray array = plugin.getAsJsonArray(KEY_REQUIRED);
                        for (JsonElement element : array) {
                            String requiredModId = element.getAsString();
                            if (ModInfo.get(requiredModId).isPresent()) {
                                required.add(requiredModId);
                                continue;
                            }
                            break block13;
                        }
                    }
                    PluginInfo.register(modId, pluginId, side, initializer, required, false);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(PluginLoader.readError(path), e);
            }
        }
    }

    public void loadPlugins() {
        this.gatherPlugins();
        if (ENABLE_TEST_PLUGIN) {
            PluginInfo.register("wthit", "waila:test", IPluginInfo.Side.BOTH, "mcp.mobius.waila.plugin.test.WailaTest", Collections.emptyList(), false);
        }
        IPluginInfo extraPlugin = null;
        ArrayList<String> legacyPlugins = new ArrayList<String>();
        for (IPluginInfo info : PluginInfo.getAll()) {
            if (info.getPluginId().equals((Object)Waila.id("extra"))) {
                extraPlugin = info;
            } else {
                this.register(info);
            }
            if (!((PluginInfo)info).isLegacy()) continue;
            legacyPlugins.add(info.getPluginId().toString());
        }
        if (extraPlugin != null) {
            this.register(extraPlugin);
        }
        if (Waila.DEV && !legacyPlugins.isEmpty()) {
            LOG.warn("Found plugins registered via legacy platform-dependant method:");
            LOG.warn(legacyPlugins.stream().collect(Collectors.joining(", ", "[", "]")));
            LOG.warn("The method will be removed on Minecraft 1.21");
        }
        Registrar.INSTANCE.lock();
        PluginConfig.reload();
    }

    private void register(IPluginInfo info) {
        LOG.info("Registering plugin {} at {}", info.getPluginId(), info.getInitializer().getClass().getCanonicalName());
        info.getInitializer().register(Registrar.INSTANCE);
    }

    private static String readError(Path path) {
        return "Failed to read [" + path + "]";
    }
}

