/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.provider;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.api.component.SpriteBarComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import mcp.mobius.waila.api.data.FluidData;
import mcp.mobius.waila.plugin.extra.config.ExtraBlacklistConfig;
import mcp.mobius.waila.plugin.extra.data.FluidDescription;
import mcp.mobius.waila.plugin.extra.provider.DataProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class FluidProvider
extends DataProvider<FluidData> {
    public static final FluidProvider INSTANCE = new FluidProvider();
    private static final String INFINITE = "\u221e";

    private FluidProvider() {
        super(FluidData.ID, FluidData.class, FluidData::new);
    }

    @Override
    protected void registerAdditions(IRegistrar registrar, int priority) {
        registrar.addConfig(FluidData.CONFIG_DISPLAY_UNIT, FluidData.Unit.MILLIBUCKETS);
        registrar.addComponent(new CauldronProvider(), TooltipPosition.BODY, Block.class, priority);
    }

    @Override
    protected void appendBody(ITooltip tooltip, FluidData data, IPluginConfig config, ResourceLocation objectId) {
        this.addFluidTooltip(tooltip, data, config);
    }

    private void addFluidTooltip(ITooltip tooltip, FluidData data, IPluginConfig config) {
        FluidData.Unit displayUnit = (FluidData.Unit)((Object)config.getEnum(FluidData.CONFIG_DISPLAY_UNIT));
        FluidData.Unit storedUnit = data.unit();
        for (FluidData.Entry<?> entry : data.entries()) {
            Object text;
            float ratio;
            FluidDescription desc = FluidDescription.getFluidDesc(entry);
            double stored = entry.stored();
            double capacity = entry.capacity();
            float f = ratio = Double.isInfinite(capacity) ? 1.0f : (float)(stored / capacity);
            if (Double.isInfinite(stored)) {
                text = INFINITE;
            } else {
                text = WailaHelper.suffix((long)FluidData.Unit.convert(storedUnit, displayUnit, stored));
                if (Double.isFinite(capacity)) {
                    text = (String)text + "/" + WailaHelper.suffix((long)FluidData.Unit.convert(storedUnit, displayUnit, capacity));
                }
            }
            text = (String)text + " " + displayUnit.symbol;
            TextureAtlasSprite sprite = desc.sprite();
            tooltip.addLine(new PairComponent(new WrappedComponent(desc.name().getString()), new SpriteBarComponent(ratio, sprite, 16, 16, desc.tint(), (Component)Component.m_237113_((String)text))));
        }
    }

    private class CauldronProvider
    implements IBlockComponentProvider {
        private CauldronProvider() {
        }

        @Override
        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            if (accessor.getData().get(FluidData.class) != null) {
                return;
            }
            if (!config.getBoolean(FluidProvider.this.enabledBlockOption)) {
                return;
            }
            if (((ExtraBlacklistConfig)FluidProvider.this.blacklistConfig.get()).getView().blockFilter.matches(accessor.getBlock())) {
                return;
            }
            FluidData fluidData = FluidDescription.getCauldronFluidData(accessor.getBlockState());
            if (fluidData != null) {
                FluidProvider.this.addFluidTooltip(tooltip, fluidData, config);
            }
        }
    }
}

