/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Log {
    private static final String PREFIX = "[WTHIT] ";
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private final Logger logger;

    private Log(Logger logger) {
        this.logger = logger;
    }

    public static Log create() {
        return new Log(LoggerFactory.getLogger(STACK_WALKER.getCallerClass()));
    }

    public void info(String msg) {
        this.logger.info(PREFIX + msg);
    }

    public void info(String msg, Object arg) {
        this.logger.info(PREFIX + msg, arg);
    }

    public void info(String msg, Object arg1, Object arg2) {
        this.logger.info(PREFIX + msg, arg1, arg2);
    }

    public void warn(String msg) {
        this.logger.warn(PREFIX + msg);
    }

    public void warn(String msg, Object arg) {
        this.logger.warn(PREFIX + msg, arg);
    }

    public void error(String msg) {
        this.logger.error(PREFIX + msg);
    }

    public void error(String msg, Object arg) {
        this.logger.error(PREFIX + msg, arg);
    }

    public void error(String msg, Throwable t) {
        this.logger.error(PREFIX + msg, t);
    }

    public void error(String msg, Object arg1, Object arg2) {
        this.logger.error(PREFIX + msg, arg1, arg2);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg, Object arg) {
        this.logger.debug(PREFIX + msg, arg);
    }

    public void debug(String msg, Object arg1, Object arg2) {
        this.logger.debug(PREFIX + msg, arg1, arg2);
    }
}

