/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.mixin;

import fuzs.diagonalfences.api.world.level.block.EightWayDirection;
import fuzs.diagonalfences.init.ModRegistry;
import fuzs.diagonalfences.world.level.block.StarCollisionBlock;
import fuzs.diagonalfences.world.phys.shapes.VoxelCollection;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IronBarsBlock.class})
abstract class IronBarsBlockMixin
extends CrossCollisionBlock
implements StarCollisionBlock {
    private boolean hasProperties;
    private Object2IntMap<BlockState> statePaletteMap;

    public IronBarsBlockMixin(float nodeWidth, float extensionWidth, float nodeHeight, float extensionHeight, float collisionY, BlockBehaviour.Properties properties) {
        super(nodeWidth, extensionWidth, nodeHeight, extensionHeight, collisionY, properties);
    }

    protected VoxelShape[] m_52326_(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        if (this.hasProperties()) {
            return this.getShapes(nodeWidth, extensionWidth, nodeHeight, extensionBottom, extensionHeight);
        }
        return super.m_52326_(nodeWidth, extensionWidth, nodeHeight, extensionBottom, extensionHeight);
    }

    protected int m_52363_(BlockState state) {
        if (this.hasProperties()) {
            if (this.statePaletteMap == null) {
                this.statePaletteMap = new Object2IntOpenHashMap();
            }
            return this.statePaletteMap.computeIfAbsent((Object)state, this::makeIndex);
        }
        return super.m_52363_(state);
    }

    public void m_7742_(BlockState state, LevelAccessor world, BlockPos pos, int flags, int recursionLeft) {
        if (this.supportsDiagonalConnections()) {
            this.updateIndirectNeighbourShapes2(state, world, pos, flags, recursionLeft);
        }
    }

    @Final
    @Shadow
    public abstract boolean m_54217_(BlockState var1, boolean var2);

    @Override
    public boolean hasProperties() {
        return this.hasProperties;
    }

    @Override
    public boolean canConnect(BlockGetter blockGetter, BlockPos position, BlockState state, Direction direction) {
        return this.m_54217_(state, state.m_60783_(blockGetter, position, direction));
    }

    @Override
    public boolean supportsDiagonalConnections() {
        return this.hasProperties() && !this.m_204297_().m_203656_(ModRegistry.NON_DIAGONAL_PANES_BLOCK_TAG);
    }

    @Override
    public boolean canConnectToMe(BlockState neighborState, EightWayDirection neighborDirectionToMe) {
        if (neighborState.m_60734_() instanceof IronBarsBlock && ((StarCollisionBlock)neighborState.m_60734_()).supportsDiagonalConnections() && this.m_54217_(neighborState, true)) {
            for (EightWayDirection neighbor : neighborDirectionToMe.getCardinalNeighbors()) {
                if (!((Boolean)neighborState.m_61143_((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)neighbor))).booleanValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public VoxelCollection[] constructStateShapes(VoxelShape nodeShape, VoxelShape[] directionalShapes, VoxelShape[] particleDirectionalShapes) {
        VoxelCollection[] stateShapes = new VoxelCollection[(int)Math.pow(2.0, directionalShapes.length)];
        for (int i = 0; i < stateShapes.length; ++i) {
            stateShapes[i] = (i & 0x10) != 0 && (i & 0x40) != 0 || (i & 0x20) != 0 && (i & 0x80) != 0 ? new VoxelCollection() : new VoxelCollection(nodeShape);
            for (int j = 0; j < directionalShapes.length; ++j) {
                if ((i & 1 << j) == 0) continue;
                stateShapes[i].addVoxelShape(directionalShapes[j], particleDirectionalShapes[j]);
            }
        }
        return stateShapes;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init$tail(BlockBehaviour.Properties properties, CallbackInfo callback) {
        if (this.hasProperties()) {
            this.m_49959_(this.addDefaultStates(this.m_49966_()));
        }
    }

    @Inject(method={"createBlockStateDefinition"}, at={@At(value="TAIL")})
    protected void createBlockStateDefinition$tail(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo callback) {
        this.hasProperties = true;
        this.createBlockStateDefinition2(builder);
    }

    @Inject(method={"getStateForPlacement"}, at={@At(value="HEAD")}, cancellable=true)
    public void getStateForPlacement$head(BlockPlaceContext context, CallbackInfoReturnable<BlockState> callback) {
        if (this.supportsDiagonalConnections()) {
            Level iblockreader = context.m_43725_();
            BlockPos basePos = context.m_8083_();
            FluidState fluidState = context.m_43725_().m_6425_(basePos);
            BlockState placementState = super.m_5573_(context);
            placementState = this.makeStateForPlacement(placementState, (BlockGetter)iblockreader, basePos, fluidState);
            callback.setReturnValue((Object)placementState);
        }
    }

    @Inject(method={"updateShape"}, at={@At(value="TAIL")}, cancellable=true)
    public void updateShape$tail(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos, CallbackInfoReturnable<BlockState> callback) {
        BlockState returnState;
        if (this.supportsDiagonalConnections() && (returnState = this.updateShape2(stateIn, facing, facingState, worldIn, currentPos, facingPos, (BlockState)callback.getReturnValue())) != null) {
            callback.setReturnValue((Object)returnState);
        }
    }
}

