/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.whats_that_slot.mixin;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.gegy.whats_that_slot.ui.SlotQueryInput;
import dev.gegy.whats_that_slot.ui.SlotQueryingScreen;
import dev.gegy.whats_that_slot.ui.state.SlotQueryController;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public class AbstractContainerScreenMixin
implements SlotQueryingScreen {
    @Shadow
    @Nullable
    protected Slot f_97734_;
    @Shadow
    @Final
    protected AbstractContainerMenu f_97732_;
    @Unique
    private final SlotQueryController queryController = new SlotQueryController((AbstractContainerScreen)this);
    @Unique
    private Slot querySlot;

    @Inject(method={"init()V"}, at={@At(value="RETURN")})
    private void init(CallbackInfo ci) {
        this.queryController.reset();
        this.querySlot = null;
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V"}, at={@At(value="RETURN")})
    private void captureAndClearFocusedSlot(PoseStack matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.querySlot = this.f_97734_;
        if (this.queryController.isActive()) {
            this.f_97734_ = null;
        }
    }

    @Inject(method={"containerTick()V"}, at={@At(value="HEAD")})
    private void tickQuery(CallbackInfo ci) {
        Window window = Minecraft.m_91087_().m_91268_();
        ItemStack carriedItem = this.f_97732_.m_142621_();
        this.queryController.tick(this.querySlot, SlotQueryInput.isRequestingQuery(window) && carriedItem.m_41619_());
    }

    @Inject(method={"renderTooltip(Lcom/mojang/blaze3d/vertex/PoseStack;II)V"}, at={@At(value="TAIL")})
    private void drawQueryDisplay(PoseStack matrices, int mouseX, int mouseY, CallbackInfo ci) {
        float delta = Minecraft.m_91087_().m_91297_();
        this.queryController.draw(matrices, mouseX, mouseY, delta);
    }

    @Inject(method={"isHovering(Lnet/minecraft/world/inventory/Slot;DD)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableItemHover(Slot slot, double pointX, double pointY, CallbackInfoReturnable<Boolean> ci) {
        InteractionResult result = this.queryController.isSlotSelected(slot, pointX, pointY);
        if (result != InteractionResult.PASS) {
            ci.setReturnValue((Object)(result == InteractionResult.SUCCESS ? 1 : 0));
        }
    }

    @Inject(method={"mouseClicked(DDI)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> ci) {
        if (this.queryController.mouseClicked(mouseX, mouseY, button)) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mouseDragged(DDIDD)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY, CallbackInfoReturnable<Boolean> ci) {
        if (this.queryController.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mouseReleased(DDI)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseReleased(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> ci) {
        if (this.queryController.mouseReleased(mouseX, mouseY, button)) {
            ci.setReturnValue((Object)true);
        }
    }

    @Override
    public boolean whats_that_slot$mouseScrolled(double amount) {
        return this.queryController.mouseScrolled(amount);
    }

    @Override
    @Nonnull
    public ItemStack whats_that_slot$getHoveredItemAt(double x, double y) {
        return this.queryController.getHoveredItemAt(x, y);
    }
}

