/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.whats_that_slot.query;

import dev.gegy.whats_that_slot.WhatsThatSlot;
import dev.gegy.whats_that_slot.mixin.AbstractContainerScreenAccess;
import dev.gegy.whats_that_slot.mixin.AbstractFurnaceMenuAccess;
import dev.gegy.whats_that_slot.query.recipe.RecipeItemResults;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public final class SlotMetadata {
    private static final Method SUPER_PLACE_TEST;
    private static final WeakHashMap<Class<?>, Boolean> DOES_OVERRIDE_PLACE_TEST;

    @Nullable
    private static Method findPlaceTestMethod() {
        for (Method method : Slot.class.getDeclaredMethods()) {
            Class<?>[] parameters = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            if (parameters.length != 1 || parameters[0] != ItemStack.class || returnType != Boolean.TYPE) continue;
            return method;
        }
        return null;
    }

    public static boolean doesOverridePlaceTest(Slot slot) {
        return DOES_OVERRIDE_PLACE_TEST.computeIfAbsent(slot.getClass(), SlotMetadata::doesOverridePlaceTest);
    }

    private static boolean doesOverridePlaceTest(Class<?> clazz) {
        Method superPlaceTest = SUPER_PLACE_TEST;
        if (superPlaceTest != null) {
            return SlotMetadata.doesOverride(clazz, superPlaceTest);
        }
        return false;
    }

    private static boolean doesOverride(Class<?> clazz, Method superMethod) {
        try {
            Method overridingMethod = clazz.getMethod(superMethod.getName(), superMethod.getParameterTypes());
            return overridingMethod.getDeclaringClass() != Slot.class;
        }
        catch (ReflectiveOperationException e) {
            return false;
        }
    }

    @Nullable
    public static Iterable<ItemStack> getCustomItems(Minecraft client, AbstractContainerScreen<?> screen, Slot slot) {
        if (client.f_91073_ != null) {
            AbstractContainerMenu menu;
            RecipeManager recipeManager = client.f_91073_.m_7465_();
            if (slot instanceof ResultSlot) {
                return new RecipeItemResults(recipeManager, RecipeType.f_44107_);
            }
            if (slot instanceof FurnaceResultSlot && (menu = ((AbstractContainerScreenAccess)screen).getMenu()) instanceof AbstractFurnaceMenuAccess) {
                AbstractFurnaceMenuAccess furnace = (AbstractFurnaceMenuAccess)menu;
                RecipeType<? extends AbstractCookingRecipe> recipeType = furnace.getRecipeType();
                return new RecipeItemResults(recipeManager, recipeType);
            }
        }
        return null;
    }

    static {
        DOES_OVERRIDE_PLACE_TEST = new WeakHashMap();
        Method placeTest = SlotMetadata.findPlaceTestMethod();
        if (placeTest == null) {
            WhatsThatSlot.LOGGER.warn("Unable to find mayPlace method on Slot! Something is very wrong, but we can safely ignore it.");
        }
        SUPER_PLACE_TEST = placeTest;
    }
}

