/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.whats_that_slot.query;

import com.google.common.collect.Iterators;
import dev.gegy.whats_that_slot.WhatsThatSlot;
import dev.gegy.whats_that_slot.collection.ConcatList;
import dev.gegy.whats_that_slot.collection.LazyFillingList;
import dev.gegy.whats_that_slot.query.GlobalItemStacks;
import dev.gegy.whats_that_slot.query.ItemStackLinkedSet;
import dev.gegy.whats_that_slot.query.MenuItemStacks;
import dev.gegy.whats_that_slot.query.QueriedItem;
import dev.gegy.whats_that_slot.query.SlotQuery;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.item.ItemStack;

public final class SlotQueryGenerator {
    private State state;
    private SlotQuery results;

    private SlotQueryGenerator(State state) {
        this.state = state;
    }

    public static SlotQueryGenerator of(AbstractContainerScreen<?> screen, Predicate<ItemStack> filter) {
        MatchingInventory state = new MatchingInventory(screen, filter);
        return new SlotQueryGenerator(state);
    }

    public static SlotQueryGenerator ofCustom(Iterable<ItemStack> items) {
        MatchingCustom state = new MatchingCustom(items);
        return new SlotQueryGenerator(state);
    }

    @Nullable
    public SlotQuery advance(BooleanSupplier shouldContinue) {
        if (this.results != null) {
            return this.results;
        }
        State state = this.state;
        while (shouldContinue.getAsBoolean()) {
            this.state = state = state.advance(shouldContinue);
            if (!(state instanceof Ready)) continue;
            Ready ready = (Ready)state;
            this.results = ready.results();
            return this.results;
        }
        return null;
    }

    public void advanceFor(Duration duration) {
        if (this.results == null) {
            long targetTime = System.nanoTime() + duration.toNanos();
            this.advance(() -> System.nanoTime() < targetTime);
        }
    }

    public SlotQuery build() {
        SlotQuery query = this.advance(() -> true);
        return Objects.requireNonNull(query);
    }

    private static interface State {
        public State advance(BooleanSupplier var1);
    }

    private static final class MatchingInventory
    implements State {
        private final Predicate<ItemStack> filter;
        private final Iterator<ItemStack> inventoryIterator;
        private final Set<ItemStack> inventoryMatches = new ItemStackLinkedSet();

        private MatchingInventory(AbstractContainerScreen<?> screen, Predicate<ItemStack> filter) {
            this.filter = filter;
            this.inventoryIterator = MenuItemStacks.of(screen).iterator();
        }

        @Override
        public State advance(BooleanSupplier shouldContinue) {
            Iterator<ItemStack> inventory = this.inventoryIterator;
            while (shouldContinue.getAsBoolean() && inventory.hasNext()) {
                ItemStack item = inventory.next();
                if (!this.filter.test(item)) continue;
                this.addInventoryMatch(item);
            }
            if (!inventory.hasNext()) {
                return new MatchingGlobal(this.filter, this.inventoryMatches);
            }
            return this;
        }

        private void addInventoryMatch(ItemStack item) {
            if ((item = item.m_41777_()).m_41613_() > 1) {
                item.m_41764_(1);
            }
            this.inventoryMatches.add(item);
        }
    }

    private static final class MatchingCustom
    implements State {
        private final Iterable<ItemStack> items;
        private final Iterator<ItemStack> itemIterator;
        private int itemCount;

        private MatchingCustom(Iterable<ItemStack> items) {
            this.items = items;
            this.itemIterator = items.iterator();
        }

        @Override
        public State advance(BooleanSupplier shouldContinue) {
            Iterator<ItemStack> iterator = this.itemIterator;
            while (shouldContinue.getAsBoolean() && iterator.hasNext()) {
                iterator.next();
                ++this.itemCount;
            }
            if (!iterator.hasNext()) {
                SlotQuery results = this.buildResults();
                return new Ready(results);
            }
            return this;
        }

        private SlotQuery buildResults() {
            Iterator items = Iterators.transform(this.items.iterator(), QueriedItem::of);
            return new SlotQuery(LazyFillingList.ofIterator(items, this.itemCount));
        }
    }

    private record Ready(SlotQuery results) implements State
    {
        @Override
        public State advance(BooleanSupplier shouldContinue) {
            return this;
        }
    }

    private static final class MatchingGlobal
    implements State {
        private final Predicate<ItemStack> globalFilter;
        private final Set<ItemStack> inventoryMatches;
        private final GlobalItemStacks globalItems = WhatsThatSlot.GLOBAL_ITEMS;
        private final Iterator<ItemStack> globalItemIterator = this.globalItems.iterator();
        private int matchCount;

        private MatchingGlobal(Predicate<ItemStack> filter, Set<ItemStack> inventoryMatches) {
            this.globalFilter = filter.and(item -> !inventoryMatches.contains(item));
            this.inventoryMatches = inventoryMatches;
        }

        @Override
        public State advance(BooleanSupplier shouldContinue) {
            Iterator<ItemStack> iterator = this.globalItemIterator;
            while (shouldContinue.getAsBoolean() && iterator.hasNext()) {
                ItemStack item = iterator.next();
                if (!this.globalFilter.test(item)) continue;
                ++this.matchCount;
            }
            if (!iterator.hasNext()) {
                SlotQuery results = this.buildResults();
                return new Ready(results);
            }
            return this;
        }

        private SlotQuery buildResults() {
            return new SlotQuery(ConcatList.of(this.buildInventoryResults(), this.buildGlobalResults()));
        }

        private List<QueriedItem> buildGlobalResults() {
            return LazyFillingList.ofIterator(Iterators.transform((Iterator)Iterators.filter(this.globalItems.iterator(), this.globalFilter::test), QueriedItem::of), this.matchCount);
        }

        private List<QueriedItem> buildInventoryResults() {
            ObjectArrayList inventoryItems = new ObjectArrayList(this.inventoryMatches.size());
            for (ItemStack match : this.inventoryMatches) {
                inventoryItems.add((Object)QueriedItem.ofHighlighted(match));
            }
            return inventoryItems;
        }
    }
}

