/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.whats_that_slot.ui.window;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.gegy.whats_that_slot.query.QueriedItem;
import dev.gegy.whats_that_slot.ui.Bounds2i;
import dev.gegy.whats_that_slot.ui.window.SlotGridLayout;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public final class SlotQueryItems
extends GuiComponent {
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static final int HIGHLIGHT_COLOR = -10180046;
    private final Bounds2i bounds;
    private final SlotGridLayout grid;
    private final List<QueriedItem> items;
    private int scrollIndexOffset;

    public SlotQueryItems(Bounds2i bounds, SlotGridLayout grid, List<QueriedItem> items) {
        this.bounds = bounds;
        this.grid = grid;
        this.items = items;
        this.m_93250_(200);
    }

    public void applyScroll(float scroll) {
        this.scrollIndexOffset = Mth.m_14143_((float)scroll) * this.grid.countX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawItems(PoseStack matrices) {
        ItemRenderer itemRenderer = CLIENT.m_91291_();
        LocalPlayer player = SlotQueryItems.CLIENT.f_91074_;
        try {
            itemRenderer.f_115093_ = this.m_93252_();
            this.grid.forEach((index, slotX, slotY) -> {
                QueriedItem item = this.getItemInSlot(index);
                if (item != null) {
                    int screenX = this.screenX(slotX);
                    int screenY = this.screenY(slotY);
                    this.drawItemSlot(matrices, itemRenderer, player, item, screenX, screenY);
                }
            });
        }
        finally {
            itemRenderer.f_115093_ = 0.0f;
        }
    }

    private void drawItemSlot(PoseStack matrices, ItemRenderer itemRenderer, LocalPlayer player, QueriedItem item, int x, int y) {
        if (item.highlighted()) {
            this.m_93179_(matrices, x, y, x + 16, y + 16, -10180046, -10180046);
        }
        itemRenderer.m_174229_((LivingEntity)player, item.itemStack(), x, y, 0);
    }

    public void drawTooltips(PoseStack matrices, int mouseX, int mouseY) {
        int focusedSlotY;
        int focusedSlotX = this.slotX(mouseX);
        if (this.grid.contains(focusedSlotX, focusedSlotY = this.slotY(mouseY))) {
            this.drawSlotTooltip(matrices, mouseX, mouseY, focusedSlotX, focusedSlotY);
        }
    }

    private void drawSlotTooltip(PoseStack matrices, int mouseX, int mouseY, int slotX, int slotY) {
        int screenX = this.screenX(slotX);
        int screenY = this.screenY(slotY);
        AbstractContainerScreen.m_169606_((PoseStack)matrices, (int)screenX, (int)screenY, (int)this.m_93252_());
        QueriedItem item = this.getItemInSlot(slotX, slotY);
        if (item != null) {
            this.renderItemTooltip(matrices, mouseX, mouseY, item.itemStack());
        }
    }

    private void renderItemTooltip(PoseStack matrices, int mouseX, int mouseY, ItemStack item) {
        Screen screen = SlotQueryItems.CLIENT.f_91080_;
        if (screen != null) {
            List tooltip = screen.m_96555_(item);
            Optional tooltipData = item.m_150921_();
            screen.m_169388_(matrices, tooltip, tooltipData, mouseX, mouseY);
        }
    }

    @Nullable
    public QueriedItem mouseClicked(double mouseX, double mouseY) {
        int slotX = this.slotX(Mth.m_14107_((double)mouseX));
        int slotY = this.slotY(Mth.m_14107_((double)mouseY));
        return this.getItemInSlot(slotX, slotY);
    }

    @Nonnull
    public ItemStack getHoveredItemAt(double x, double y) {
        int slotY;
        int slotX = this.slotX(Mth.m_14107_((double)x));
        QueriedItem item = this.getItemInSlot(slotX, slotY = this.slotY(Mth.m_14107_((double)y)));
        if (item != null) {
            return item.itemStack();
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    private QueriedItem getItemInSlot(int x, int y) {
        if (this.grid.contains(x, y)) {
            return this.getItemInSlot(this.grid.index(x, y));
        }
        return null;
    }

    @Nullable
    private QueriedItem getItemInSlot(int index) {
        int listIndex = index + this.scrollIndexOffset;
        if (listIndex >= 0 && listIndex < this.items.size()) {
            return this.items.get(listIndex);
        }
        return null;
    }

    private int slotX(int mouseX) {
        return this.grid.slotX(mouseX - this.bounds.x0());
    }

    private int slotY(int mouseY) {
        return this.grid.slotY(mouseY - this.bounds.y0());
    }

    private int screenX(int slotX) {
        return this.grid.screenX(slotX) + this.bounds.x0();
    }

    private int screenY(int slotY) {
        return this.grid.screenY(slotY) + this.bounds.y0();
    }
}

