/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.whats_that_slot.ui.window.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.gegy.whats_that_slot.query.QueriedItem;
import dev.gegy.whats_that_slot.query.SlotQuery;
import dev.gegy.whats_that_slot.ui.Bounds2i;
import dev.gegy.whats_that_slot.ui.scroll.ScrollView;
import dev.gegy.whats_that_slot.ui.scroll.Scrollbar;
import dev.gegy.whats_that_slot.ui.window.SlotGridLayout;
import dev.gegy.whats_that_slot.ui.window.SlotQueryActions;
import dev.gegy.whats_that_slot.ui.window.SlotQueryItems;
import dev.gegy.whats_that_slot.ui.window.texture.SlotQueryWindow;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public final class ScrolledSlotQueryWindow
extends GuiComponent
implements SlotQueryWindow {
    private static final ResourceLocation TEXTURE = new ResourceLocation("whats_that_slot", "textures/gui/scrolled_window.png");
    private static final int TEXTURE_WIDTH = 128;
    private static final int TEXTURE_HEIGHT = 128;
    private static final int WIDTH = 117;
    private static final int HEIGHT = 102;
    private static final int SLOTS_X0 = 7;
    private static final int SLOTS_Y0 = 7;
    private static final int SCROLLBAR_X = 100;
    private static final int SCROLLBAR_Y = 7;
    public static final int SCROLLER_WIDTH = 10;
    public static final int SCROLLER_HEIGHT = 15;
    private static final int SCROLLER_U = 117;
    private static final int SCROLLER_V = 0;
    private static final int SELECTED_SCROLLER_V = 15;
    private final SlotQueryActions actions;
    private final SlotQueryItems items;
    private final ScrollView scrollView;
    private final Scrollbar scrollbar;
    private final Bounds2i scrollerBounds;
    private double scrollerSelectY;
    private boolean selectedScroller;

    public ScrolledSlotQueryWindow(SlotQueryActions actions, SlotGridLayout grid, SlotQuery query, ScrollView scrollView) {
        this.actions = actions;
        this.items = new SlotQueryItems(grid.screenBounds(7, 7), grid, query.items());
        this.scrollView = scrollView;
        int scrollbarHeight = grid.countY() * 18 - 2;
        this.scrollbar = new Scrollbar(scrollbarHeight, 15);
        this.scrollerBounds = Bounds2i.ofSize(100, 7, 10, 15);
        this.m_93250_(200);
    }

    @Override
    public void draw(PoseStack matrices, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.drawBackground(matrices);
        this.drawScroller(matrices);
        this.items.drawItems(matrices);
        this.items.drawTooltips(matrices, mouseX, mouseY);
    }

    private void drawBackground(PoseStack matrices) {
        this.m_93228_(matrices, 0, 0, 0, 0, 117, 102);
    }

    private void drawScroller(PoseStack matrices) {
        Bounds2i scroller = this.scrollView.scrollerFromTop(this.scrollbar, this.scrollerBounds);
        int v = this.selectedScroller ? 15 : 0;
        this.blit(matrices, scroller, 117, v);
    }

    @Override
    public Bounds2i bounds() {
        return Bounds2i.ofSize(0, 0, 117, 102);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY) {
        Bounds2i scroller = this.scrollView.scrollerFromTop(this.scrollbar, this.scrollerBounds);
        if (scroller.contains(mouseX, mouseY)) {
            this.mouseClickedScroller(mouseY, scroller);
            return true;
        }
        QueriedItem queriedItem = this.items.mouseClicked(mouseX, mouseY);
        if (queriedItem != null) {
            return this.actions.selectItem(queriedItem);
        }
        return false;
    }

    private void mouseClickedScroller(double mouseY, Bounds2i scroller) {
        this.selectedScroller = true;
        this.scrollerSelectY = mouseY - (double)scroller.y0();
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY) {
        if (this.selectedScroller) {
            int scrollerY = Mth.m_14107_((double)(mouseY - this.scrollerSelectY - 7.0));
            float scroll = this.scrollView.scrollerToScroll(scrollerY, this.scrollbar);
            this.scrollView.setScroll(scroll);
            this.onScrollChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY) {
        if (this.selectedScroller) {
            this.selectedScroller = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double amount) {
        this.scrollView.mouseScrolled(amount);
        this.onScrollChanged();
        return true;
    }

    private void onScrollChanged() {
        this.items.applyScroll(this.scrollView.scroll());
    }

    @Override
    @Nonnull
    public ItemStack getHoveredItemAt(double x, double y) {
        return this.items.getHoveredItemAt(x, y);
    }

    public void m_93228_(PoseStack matrices, int x, int y, int u, int v, int width, int height) {
        ScrolledSlotQueryWindow.m_93143_((PoseStack)matrices, (int)x, (int)y, (int)this.m_93252_(), (float)u, (float)v, (int)width, (int)height, (int)128, (int)128);
    }

    private void blit(PoseStack matrices, Bounds2i bounds, int u, int v) {
        this.m_93228_(matrices, bounds.x0(), bounds.y0(), u, v, bounds.width(), bounds.height());
    }
}

