/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.network.server;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import subaraki.paintings.network.IPacketBase;
import subaraki.paintings.network.NetworkHandler;
import subaraki.paintings.network.ProcessServerPacket;
import subaraki.paintings.network.client.CPacketPainting;

public class SPacketPainting
implements IPacketBase {
    private ResourceLocation variantName;
    private int entityID;

    public SPacketPainting() {
    }

    public SPacketPainting(ResourceLocation Name, int entityID) {
        this.variantName = Name;
        this.entityID = entityID;
    }

    public SPacketPainting(FriendlyByteBuf buff) {
        this.decode(buff);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.variantName.toString());
        buf.writeInt(this.entityID);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.variantName = new ResourceLocation(buf.m_130136_(256));
        this.entityID = buf.readInt();
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)context.get()).getSender();
            if (serverPlayer != null) {
                ProcessServerPacket.handle(serverPlayer.f_19853_, serverPlayer, this.entityID, this.variantName, (painting, player) -> NetworkHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new CPacketPainting(painting, new ResourceLocation[]{this.variantName})));
            }
        });
        context.get().setPacketHandled(true);
    }

    @Override
    public void encrypt(int id) {
        NetworkHandler.NETWORK.registerMessage(id, SPacketPainting.class, SPacketPainting::encode, SPacketPainting::new, SPacketPainting::handle);
    }
}

