/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blockentities;

import com.finallion.graveyard.init.TGTileEntities;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class GravestoneBlockEntity
extends BlockEntity {
    public static final int LINES = 4;
    private static final String[] RAW_TEXT_FIELD_NAMES = new String[]{"Text1", "Text2", "Text3", "Text4"};
    private static final String[] FILTERED_TEXT_FIELD_NAMES = new String[]{"FilteredText1", "FilteredText2", "FilteredText3", "FilteredText4"};
    private final Component[] messages = new Component[]{Component.m_237119_(), Component.m_237119_(), Component.m_237119_(), Component.m_237119_()};
    private final Component[] filteredMessages = new Component[]{Component.m_237119_(), Component.m_237119_(), Component.m_237119_(), Component.m_237119_()};
    private boolean isEditable = true;
    @Nullable
    private UUID playerWhoMayEdit;
    @Nullable
    private FormattedCharSequence[] renderMessages;
    private boolean renderMessagedFiltered;
    private DyeColor color = DyeColor.BLACK;
    private boolean hasGlowingText;

    public GravestoneBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TGTileEntities.GRAVESTONE_BLOCK_ENTITY.get(), pos, state);
    }

    protected void m_183515_(CompoundTag p_187515_) {
        super.m_183515_(p_187515_);
        for (int i = 0; i < 4; ++i) {
            Component component = this.messages[i];
            String s = Component.Serializer.m_130703_((Component)component);
            p_187515_.m_128359_(RAW_TEXT_FIELD_NAMES[i], s);
            Component component1 = this.filteredMessages[i];
            if (component1.equals(component)) continue;
            p_187515_.m_128359_(FILTERED_TEXT_FIELD_NAMES[i], Component.Serializer.m_130703_((Component)component1));
        }
        p_187515_.m_128359_("Color", this.color.m_41065_());
        p_187515_.m_128379_("GlowingText", this.hasGlowingText);
    }

    public void m_142466_(CompoundTag p_155716_) {
        this.isEditable = false;
        super.m_142466_(p_155716_);
        this.color = DyeColor.m_41057_((String)p_155716_.m_128461_("Color"), (DyeColor)DyeColor.BLACK);
        for (int i = 0; i < 4; ++i) {
            Component component;
            String s = p_155716_.m_128461_(RAW_TEXT_FIELD_NAMES[i]);
            this.messages[i] = component = this.loadLine(s);
            String s1 = FILTERED_TEXT_FIELD_NAMES[i];
            this.filteredMessages[i] = p_155716_.m_128425_(s1, 8) ? this.loadLine(p_155716_.m_128461_(s1)) : component;
        }
        this.renderMessages = null;
        this.hasGlowingText = p_155716_.m_128471_("GlowingText");
    }

    private Component loadLine(String p_155712_) {
        Component component = this.deserializeTextSafe(p_155712_);
        if (this.f_58857_ instanceof ServerLevel) {
            try {
                return ComponentUtils.m_130731_((CommandSourceStack)this.createCommandSourceStack(null), (Component)component, (Entity)null, (int)0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return component;
    }

    private Component deserializeTextSafe(String p_155721_) {
        try {
            MutableComponent component = Component.Serializer.m_130701_((String)p_155721_);
            if (component != null) {
                return component;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Component.m_237119_();
    }

    public Component getMessage(int p_155707_, boolean p_155708_) {
        return this.getMessages(p_155708_)[p_155707_];
    }

    public void setMessage(int p_59733_, Component p_59734_) {
        this.setMessage(p_59733_, p_59734_, p_59734_);
    }

    public void setMessage(int p_155703_, Component p_155704_, Component p_155705_) {
        this.messages[p_155703_] = p_155704_;
        this.filteredMessages[p_155703_] = p_155705_;
        this.renderMessages = null;
    }

    public FormattedCharSequence[] getRenderMessages(boolean p_155718_, Function<Component, FormattedCharSequence> p_155719_) {
        if (this.renderMessages == null || this.renderMessagedFiltered != p_155718_) {
            this.renderMessagedFiltered = p_155718_;
            this.renderMessages = new FormattedCharSequence[4];
            for (int i = 0; i < 4; ++i) {
                this.renderMessages[i] = p_155719_.apply(this.getMessage(i, p_155718_));
            }
        }
        return this.renderMessages;
    }

    private Component[] getMessages(boolean p_155725_) {
        return p_155725_ ? this.filteredMessages : this.messages;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean m_6326_() {
        return true;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean p_59747_) {
        this.isEditable = p_59747_;
        if (!p_59747_) {
            this.playerWhoMayEdit = null;
        }
    }

    public void setAllowedPlayerEditor(UUID p_155714_) {
        this.playerWhoMayEdit = p_155714_;
    }

    @Nullable
    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    public boolean executeClickCommands(ServerPlayer p_155710_) {
        for (Component component : this.getMessages(p_155710_.m_143387_())) {
            Style style = component.m_7383_();
            ClickEvent clickevent = style.m_131182_();
            if (clickevent == null || clickevent.m_130622_() != ClickEvent.Action.RUN_COMMAND) continue;
            p_155710_.m_20194_().m_129892_().m_230957_(this.createCommandSourceStack(p_155710_), clickevent.m_130623_());
        }
        return true;
    }

    public CommandSourceStack createCommandSourceStack(@Nullable ServerPlayer p_59736_) {
        String s = p_59736_ == null ? "Sign" : p_59736_.m_7755_().getString();
        MutableComponent component = p_59736_ == null ? Component.m_237113_((String)"Sign") : p_59736_.m_5446_();
        return new CommandSourceStack(CommandSource.f_80164_, Vec3.m_82512_((Vec3i)this.f_58858_), Vec2.f_82462_, (ServerLevel)this.f_58857_, 2, s, (Component)component, this.f_58857_.m_7654_(), (Entity)p_59736_);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean setColor(DyeColor p_59740_) {
        if (p_59740_ != this.getColor()) {
            this.color = p_59740_;
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean hasGlowingText() {
        return this.hasGlowingText;
    }

    public boolean setHasGlowingText(boolean p_155723_) {
        if (this.hasGlowingText != p_155723_) {
            this.hasGlowingText = p_155723_;
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

