/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import com.finallion.graveyard.util.MathUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class FallingCorpse
extends Monster
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final AnimationBuilder FALLING_ANIMATION = new AnimationBuilder().addAnimation("falling", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder LANDING_ANIMATION = new AnimationBuilder().addAnimation("landing", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE).addAnimation("despawn", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private static final EntityDataAccessor<Boolean> IS_FALLING = SynchedEntityData.m_135353_(FallingCorpse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_COLLIDED = SynchedEntityData.m_135353_(FallingCorpse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final float DAMAGE = 10.0f;
    private int landingCounter = 40;
    private int levitationCounter = 15;
    private float rotation;

    public FallingCorpse(EntityType<? extends FallingCorpse> entityType, Level world) {
        super(entityType, world);
        this.setRotation(this.m_217043_().m_188503_(361));
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isFalling()) {
            event.getController().setAnimation(this.FALLING_ANIMATION);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(this.LANDING_ANIMATION);
        return PlayState.CONTINUE;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        this.f_19853_.m_5594_(null, this.m_20183_(), SoundEvents.f_12037_, SoundSource.HOSTILE, 2.0f, 1.0f);
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return source == DamageSource.f_19317_;
    }

    public void m_183634_() {
        this.setIsFalling(false);
        super.m_183634_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_FALLING, (Object)true);
        this.f_19804_.m_135372_(HAS_COLLIDED, (Object)false);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22278_, 5.0);
    }

    public void m_8107_() {
        if (this.m_20075_().m_60795_()) {
            for (int i = 0; i < 20; ++i) {
                BlockPos pos = this.m_20183_().m_7918_(0, -i, 0);
                BlockState state = this.f_19853_.m_8055_(pos);
                if (state.m_60795_() || !state.m_60804_((BlockGetter)this.f_19853_, pos)) continue;
                MathUtil.createParticleDisk(this.f_19853_, (double)pos.m_123341_() + this.f_19796_.m_188500_(), (double)pos.m_123342_() + 1.3, (double)pos.m_123343_() + this.f_19796_.m_188500_(), 0.0, 0.0, 0.0, 1.0f, DustParticleOptions.f_123656_, this.m_217043_());
                break;
            }
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        if (this.levitationCounter > 0) {
            --this.levitationCounter;
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04, 0.0));
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        if (!this.isFalling() && this.landingCounter > 0) {
            --this.landingCounter;
        }
        if (this.landingCounter <= 0) {
            this.m_146870_();
        }
        if (!this.f_19853_.m_8055_(this.m_20183_().m_7495_()).m_60795_()) {
            this.setIsFalling(false);
        }
        if (this.m_20075_().m_60795_()) {
            this.setIsFalling(true);
        }
        super.m_8024_();
    }

    public void m_6123_(Player p_20081_) {
        if (!this.hasCollided() && this.isFalling()) {
            p_20081_.m_6469_(DamageSource.f_19318_, 10.0f);
            this.setHasCollided(true);
        }
        super.m_6123_(p_20081_);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean isFalling() {
        return (Boolean)this.f_19804_.m_135370_(IS_FALLING);
    }

    public void setIsFalling(boolean isFalling) {
        this.f_19804_.m_135381_(IS_FALLING, (Object)isFalling);
    }

    public boolean hasCollided() {
        return (Boolean)this.f_19804_.m_135370_(HAS_COLLIDED);
    }

    public void setHasCollided(boolean hasCollided) {
        this.f_19804_.m_135381_(HAS_COLLIDED, (Object)hasCollided);
    }
}

