/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import com.finallion.graveyard.blocks.BrazierBlock;
import com.finallion.graveyard.entities.HostileGraveyardEntity;
import com.finallion.graveyard.init.TGAdvancements;
import com.finallion.graveyard.init.TGSounds;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class WraithEntity
extends HostileGraveyardEntity
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier ATTACKING_SPEED_BOOST = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", (double)0.2f, AttributeModifier.Operation.ADDITION);
    private final AnimationBuilder DEATH_ANIMATION = new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder SPAWN_ANIMATION = new AnimationBuilder().addAnimation("spawn", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationBuilder MOVE_ANIMATION = new AnimationBuilder().addAnimation("moving", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder ATTACK_ANIMATION = new AnimationBuilder().addAnimation("attacking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected final byte ANIMATION_SPAWN = 0;
    protected final byte ANIMATION_IDLE = 1;
    protected final byte ANIMATION_DEATH = (byte)2;
    protected final byte ANIMATION_ATTACK = (byte)3;
    protected static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.m_135353_(WraithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private boolean spawned = false;
    private int spawnTimer;
    @Nullable
    private BlockPos homePosition;
    private int timeSinceExtinguish;

    public WraithEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world, "wraith");
        this.f_21342_ = new FlyingMoveControl((Mob)this, 0, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public void m_6478_(MoverType p_33997_, Vec3 p_33998_) {
        super.m_6478_(p_33997_, p_33998_);
        this.m_20101_();
    }

    public void m_7601_(BlockState p_20006_, Vec3 p_20007_) {
        if (!p_20006_.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(p_20006_, p_20007_);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WraithMeleeGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new ExtinguishGoal());
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected PathNavigation m_6037_(Level p_27815_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_27815_){

            public boolean m_6342_(BlockPos p_27947_) {
                return !this.f_26495_.m_8055_(p_27947_.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                super.m_7638_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource) {
            Entity entity = source.m_7640_();
            if (entity instanceof Arrow) {
                return false;
            }
            return super.m_6469_(source, amount);
        }
        return super.m_6469_(source, amount);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION, (Object)1);
        this.spawnTimer = 20;
        this.setAnimation((byte)0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20242_(true);
        if (this.getHomePosition() == null) {
            this.homePosition = this.m_20097_();
        }
        if (this.f_19796_.m_188501_() < 0.025f) {
            this.addParticles();
        }
    }

    private BlockPos getHomePosition() {
        return this.homePosition;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.homePosition != null) {
            nbt.m_128405_("BoundX", this.homePosition.m_123341_());
            nbt.m_128405_("BoundY", this.homePosition.m_123342_());
            nbt.m_128405_("BoundZ", this.homePosition.m_123343_());
        }
        nbt.m_128405_("timeSinceExtinguish", this.timeSinceExtinguish);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("BoundX")) {
            this.homePosition = new BlockPos(nbt.m_128451_("BoundX"), nbt.m_128451_("BoundY"), nbt.m_128451_("BoundZ"));
        }
        this.timeSinceExtinguish = nbt.m_128451_("timeSinceExtinguish");
    }

    @Override
    public void m_8107_() {
        --this.spawnTimer;
        if (this.f_19853_.m_5776_() && this.spawnTimer >= 0 && this.spawned) {
            this.addParticles();
        }
        if (this.f_19853_.m_5776_() && this.spawnTimer >= 0) {
            this.f_19853_.m_5594_(null, this.m_20097_(), SoundEvents.f_12394_, SoundSource.BLOCKS, 2.5f, -10.0f);
        }
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22280_);
        if (!this.m_5912_()) {
            attributeinstance.m_22130_(ATTACKING_SPEED_BOOST);
        } else if (!attributeinstance.m_22109_(ATTACKING_SPEED_BOOST)) {
            attributeinstance.m_22118_(ATTACKING_SPEED_BOOST);
        }
        if (!this.m_6084_()) {
            this.addDeathParticles();
        }
        super.m_8107_();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        for (int i = 0; i < 5; ++i) {
            this.m_5496_((SoundEvent)TGSounds.WRAITH_AMBIENT.get(), 2.0f, -10.0f);
        }
        if (this.f_20919_ == 42 && !this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void addParticles() {
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_() + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()), this.m_20186_(), this.m_20189_() + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()), 0.0, (double)0.05f, 0.0);
    }

    private void addDeathParticles() {
        for (int i = 0; i < 10; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()), this.m_20186_() + 1.0, this.m_20189_() + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()), 0.0, (double)0.05f, 0.0);
        }
    }

    int getTimeSinceExtinguish() {
        return this.timeSinceExtinguish;
    }

    void addExtinguishCounter() {
        ++this.timeSinceExtinguish;
    }

    public boolean hasHomePosition() {
        return this.homePosition != null;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource == DamageSource.f_19314_ || damageSource == DamageSource.f_19312_ || damageSource == DamageSource.f_19325_ || damageSource == DamageSource.f_19309_ || damageSource == DamageSource.f_19316_ || damageSource == DamageSource.f_19322_ || damageSource == DamageSource.f_19315_ || damageSource == DamageSource.f_19321_) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        boolean isMoving;
        AnimationController controller = event.getController();
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean bl = isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        if (this.m_21224_()) {
            controller.setAnimation(this.DEATH_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (this.spawnTimer < 0) {
            if (this.m_5912_()) {
                controller.setAnimation(this.ATTACK_ANIMATION);
            } else if (isMoving) {
                controller.setAnimation(this.MOVE_ANIMATION);
            } else {
                controller.setAnimation(this.IDLE_ANIMATION);
            }
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicate2(AnimationEvent<E> event) {
        if (this.getAnimation() == 0) {
            event.getController().setAnimation(this.SPAWN_ANIMATION);
            this.spawned = true;
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 6.5).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22280_, 0.35);
    }

    public byte getAnimation() {
        return (Byte)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller2", 0.0f, this::predicate2));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    boolean closerThan(BlockPos pos, int distance) {
        if (pos == null) {
            return false;
        }
        return pos.m_123314_((Vec3i)this.m_20097_(), (double)distance);
    }

    public void m_8032_() {
        this.m_5496_((SoundEvent)TGSounds.WRAITH_AMBIENT.get(), 1.5f, -10.0f);
    }

    protected void m_6677_(DamageSource source) {
        this.m_5496_((SoundEvent)TGSounds.WRAITH_HURT.get(), 1.0f, -10.0f);
    }

    public boolean m_7337_(Entity other) {
        if (other instanceof WraithEntity) {
            return false;
        }
        return super.m_7337_(other);
    }

    protected void m_21229_() {
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public boolean m_142535_(float p_148750_, float p_148751_, DamageSource p_148752_) {
        return false;
    }

    protected void m_7840_(double p_27754_, boolean p_27755_, BlockState p_27756_, BlockPos p_27757_) {
    }

    private static void triggerAdvancement(WraithEntity wraith, boolean bool) {
        Player player;
        if (bool && (player = wraith.f_19853_.m_45930_((Entity)wraith, 10.0)) instanceof ServerPlayer) {
            TGAdvancements.DIM_LIGHT.trigger((ServerPlayer)player);
        }
    }

    class WraithMeleeGoal
    extends MeleeAttackGoal {
        WraithMeleeGoal(PathfinderMob mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    private class ExtinguishGoal
    extends Goal {
        ExtinguishGoal() {
        }

        public boolean m_8036_() {
            if (WraithEntity.this.getTimeSinceExtinguish() >= 10) {
                return false;
            }
            return !(WraithEntity.this.f_19796_.m_188501_() < 0.3f);
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8037_() {
            if (WraithEntity.this.f_19796_.m_188503_(this.m_183277_(10)) == 0) {
                for (int i = 1; i <= 2; ++i) {
                    BlockPos blockPos = WraithEntity.this.m_20097_().m_6625_(i);
                    BlockState blockState = WraithEntity.this.f_19853_.m_8055_(blockPos);
                    Block block = blockState.m_60734_();
                    boolean bl = false;
                    boolean torchAndLantern = false;
                    if (blockState.m_204336_(BlockTags.f_144265_)) {
                        if (block instanceof CandleBlock) {
                            if (((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                                bl = true;
                            }
                        } else if (block instanceof BrazierBlock && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                            bl = true;
                        }
                        if (bl) {
                            WraithEntity.this.f_19853_.m_5594_((Player)null, blockPos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            WraithEntity.this.f_19853_.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
                            WraithEntity.this.addExtinguishCounter();
                            WraithEntity.triggerAdvancement(WraithEntity.this, bl);
                            return;
                        }
                    }
                    if (WraithEntity.this.f_19796_.m_188503_(10) != 0) continue;
                    if (blockState.m_60713_(Blocks.f_50081_)) {
                        WraithEntity.this.f_19853_.m_7731_(blockPos, Blocks.f_50139_.m_49966_(), 3);
                        torchAndLantern = true;
                    } else if (blockState.m_60713_(Blocks.f_50681_)) {
                        WraithEntity.this.f_19853_.m_7731_(blockPos, (BlockState)((BlockState)Blocks.f_50682_.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61435_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_))), 3);
                        torchAndLantern = true;
                    } else if (blockState.m_60713_(Blocks.f_50082_)) {
                        WraithEntity.this.f_19853_.m_7731_(blockPos, (BlockState)Blocks.f_50140_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_))), 3);
                        torchAndLantern = true;
                    }
                    if (!torchAndLantern) continue;
                    WraithEntity.this.f_19853_.m_5594_((Player)null, blockPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    WraithEntity.this.addExtinguishCounter();
                    return;
                }
            }
        }
    }

    class WraithWanderAroundGoal
    extends Goal {
        private static final int MAX_DISTANCE = 15;

        WraithWanderAroundGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return WraithEntity.this.f_21344_.m_26571_() && WraithEntity.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return WraithEntity.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                WraithEntity.this.f_21344_.m_26536_(WraithEntity.this.f_21344_.m_7864_(new BlockPos(vec3), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 vec3d2;
            if (!WraithEntity.this.closerThan(WraithEntity.this.homePosition, 15) && WraithEntity.this.hasHomePosition()) {
                Vec3 vec3dx = Vec3.m_82512_((Vec3i)WraithEntity.this.homePosition);
                vec3d2 = vec3dx.m_82546_(WraithEntity.this.m_20182_()).m_82541_();
            } else {
                vec3d2 = WraithEntity.this.m_20252_(0.0f);
            }
            Vec3 vec3d3 = HoverRandomPos.m_148465_((PathfinderMob)WraithEntity.this, (int)8, (int)2, (double)vec3d2.f_82479_, (double)vec3d2.f_82481_, (float)1.5707964f, (int)2, (int)1);
            return vec3d3 != null ? vec3d3 : AirAndWaterRandomPos.m_148357_((PathfinderMob)WraithEntity.this, (int)8, (int)2, (int)-2, (double)vec3d2.f_82479_, (double)vec3d2.f_82481_, (double)1.5707963705062866);
        }
    }
}

