/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.BrewingStand;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import java.util.List;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.BrewingStand.AnimatedResultButton;
import marsh.town.brb.BrewingStand.RecipeBookGroup;
import marsh.town.brb.BrewingStand.RecipeBookWidget;
import marsh.town.brb.BrewingStand.Result;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RecipeBookResults {
    private List<Result> recipeCollection;
    public final List<AnimatedResultButton> resultButtons = Lists.newArrayListWithCapacity((int)20);
    private int pageCount;
    private int currentPage;
    private StateSwitchingButton nextPageButton;
    private StateSwitchingButton prevPageButton;
    private Minecraft client;
    private AnimatedResultButton hoveredResultButton;
    private Result lastClickedRecipe;
    RecipeBookGroup group;
    private BrewingStandMenu brewingStandScreenHandler;

    public RecipeBookResults() {
        for (int i = 0; i < 20; ++i) {
            this.resultButtons.add(new AnimatedResultButton());
        }
    }

    public void initialize(Minecraft client, int parentLeft, int parentTop, BrewingStandMenu brewingStandScreenHandler) {
        this.client = client;
        this.brewingStandScreenHandler = brewingStandScreenHandler;
        for (int i = 0; i < this.resultButtons.size(); ++i) {
            this.resultButtons.get(i).setPos(parentLeft + 11 + 25 * (i % 5), parentTop + 31 + 25 * (i / 5));
        }
        this.nextPageButton = new StateSwitchingButton(parentLeft + 93, parentTop + 137, 12, 17, false);
        this.nextPageButton.m_94624_(1, 208, 13, 18, RecipeBookWidget.TEXTURE);
        this.prevPageButton = new StateSwitchingButton(parentLeft + 38, parentTop + 137, 12, 17, true);
        this.prevPageButton.m_94624_(1, 208, 13, 18, RecipeBookWidget.TEXTURE);
    }

    public void setResults(List<Result> recipeCollection, boolean resetCurrentPage, RecipeBookGroup group) {
        this.recipeCollection = recipeCollection;
        this.group = group;
        this.pageCount = (int)Math.ceil((double)recipeCollection.size() / 20.0);
        if (this.pageCount <= this.currentPage || resetCurrentPage) {
            this.currentPage = 0;
        }
        this.refreshResultButtons();
    }

    private void refreshResultButtons() {
        if (this.pageCount == 0 && this.currentPage == -1) {
            this.currentPage = 0;
            return;
        }
        int i = 20 * this.currentPage;
        for (int j = 0; j < this.resultButtons.size(); ++j) {
            AnimatedResultButton animatedResultButton = this.resultButtons.get(j);
            if (i + j < this.recipeCollection.size()) {
                Result output = this.recipeCollection.get(i + j);
                animatedResultButton.showPotionRecipe(output, this.group, this.brewingStandScreenHandler);
                animatedResultButton.f_93624_ = true;
                continue;
            }
            animatedResultButton.f_93624_ = false;
        }
        this.hideShowPageButtons();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        AnimatedResultButton animatedResultButton;
        if (BetterRecipeBook.config.scrolling.enableScrolling) {
            if (this.nextPageButton.m_6375_(mouseX, mouseY, button)) {
                if (this.currentPage >= this.pageCount - 1) {
                    this.currentPage = -1;
                }
            } else if (this.prevPageButton.m_6375_(mouseX, mouseY, button) && this.currentPage <= 0) {
                this.currentPage = this.pageCount;
            }
        }
        this.lastClickedRecipe = null;
        if (this.nextPageButton.m_6375_(mouseX, mouseY, button)) {
            ++this.currentPage;
            this.refreshResultButtons();
            return true;
        }
        if (this.prevPageButton.m_6375_(mouseX, mouseY, button)) {
            --this.currentPage;
            this.refreshResultButtons();
            return true;
        }
        Iterator<AnimatedResultButton> var10 = this.resultButtons.iterator();
        do {
            if (var10.hasNext()) continue;
            return false;
        } while (!(animatedResultButton = var10.next()).m_6375_(mouseX, mouseY, button));
        if (button == 0) {
            this.lastClickedRecipe = animatedResultButton.getRecipe();
        }
        return true;
    }

    public void drawTooltip(PoseStack matrices, int x, int y) {
        if (this.client.f_91080_ != null && this.hoveredResultButton != null) {
            this.client.f_91080_.m_96597_(matrices, this.hoveredResultButton.getTooltip(), x, y);
        }
    }

    public Result getLastClickedRecipe() {
        return this.lastClickedRecipe;
    }

    private void hideShowPageButtons() {
        if (BetterRecipeBook.config.scrolling.scrollAround && BetterRecipeBook.config.scrolling.enableScrolling && this.pageCount >= 1) {
            this.nextPageButton.f_93624_ = true;
            this.prevPageButton.f_93624_ = true;
        } else {
            this.nextPageButton.f_93624_ = this.pageCount > 1 && this.currentPage < this.pageCount - 1;
            this.prevPageButton.f_93624_ = this.pageCount > 1 && this.currentPage > 0;
        }
    }

    public void draw(PoseStack matrices, int x, int y, int mouseX, int mouseY, float delta) {
        if (BetterRecipeBook.queuedScroll != 0 && BetterRecipeBook.config.scrolling.enableScrolling) {
            int queuedPage = BetterRecipeBook.queuedScroll + this.currentPage;
            if (queuedPage <= this.pageCount - 1 && queuedPage >= 0) {
                this.currentPage += BetterRecipeBook.queuedScroll;
            } else if (BetterRecipeBook.config.scrolling.scrollAround) {
                if (queuedPage < 0) {
                    this.currentPage = this.pageCount - 1;
                } else if (queuedPage > this.pageCount - 1) {
                    this.currentPage = 0;
                }
            }
            this.refreshResultButtons();
            BetterRecipeBook.queuedScroll = 0;
        }
        if (this.pageCount > 1) {
            int var10000 = this.currentPage + 1;
            String string = var10000 + "/" + this.pageCount;
            int i = this.client.f_91062_.m_92895_(string);
            this.client.f_91062_.m_92883_(matrices, string, (float)(x - i / 2 + 73), (float)(y + 141), -1);
        }
        this.hoveredResultButton = null;
        for (AnimatedResultButton animatedResultButton : this.resultButtons) {
            animatedResultButton.m_6305_(matrices, mouseX, mouseY, delta);
            if (!animatedResultButton.f_93624_ || !animatedResultButton.m_198029_()) continue;
            this.hoveredResultButton = animatedResultButton;
        }
        this.prevPageButton.m_6305_(matrices, mouseX, mouseY, delta);
        this.nextPageButton.m_6305_(matrices, mouseX, mouseY, delta);
    }
}

