/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.BrewingStand;

import marsh.town.brb.BrewingStand.PlatformPotionUtil;
import marsh.town.brb.BrewingStand.RecipeBookGroup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.ItemLike;

public class Result {
    public ItemStack ingredient;
    public PotionBrewing.Mix<?> recipe;
    public ResourceLocation input;

    public Result(ItemStack ingredient, PotionBrewing.Mix<?> recipe) {
        this.ingredient = ingredient;
        this.recipe = recipe;
        this.input = Registry.f_122828_.m_7981_((Object)PlatformPotionUtil.getFrom(recipe));
    }

    public boolean hasIngredient(BrewingStandMenu handledScreen) {
        for (ItemStack itemStack : PlatformPotionUtil.getIngredient(this.recipe).m_43908_()) {
            for (Slot slot : handledScreen.f_38839_) {
                if (!itemStack.m_41720_().equals(slot.m_7993_().m_41720_())) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack inputAsItemStack(RecipeBookGroup group) {
        Potion inputPotion = PlatformPotionUtil.getFrom(this.recipe);
        ResourceLocation identifier = Registry.f_122828_.m_7981_((Object)inputPotion);
        ItemStack inputStack = group == RecipeBookGroup.BREWING_SPLASH_POTION ? new ItemStack((ItemLike)Items.f_42736_) : (group == RecipeBookGroup.BREWING_LINGERING_POTION ? new ItemStack((ItemLike)Items.f_42739_) : new ItemStack((ItemLike)Items.f_42589_));
        inputStack.m_41784_().m_128359_("Potion", identifier.toString());
        return inputStack;
    }

    public boolean hasInput(RecipeBookGroup group, BrewingStandMenu handledScreen) {
        ItemStack inputStack = this.inputAsItemStack(group);
        for (Slot slot : handledScreen.f_38839_) {
            ItemStack itemStack = slot.m_7993_();
            if (inputStack.m_41783_() == null) {
                return false;
            }
            if (!inputStack.m_41783_().equals((Object)itemStack.m_41783_()) || !inputStack.m_41720_().equals(itemStack.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public boolean hasMaterials(RecipeBookGroup group, BrewingStandMenu handledScreen) {
        boolean hasIngredient = this.hasIngredient(handledScreen);
        boolean hasInput = this.hasInput(group, handledScreen);
        return hasIngredient && hasInput;
    }
}

